const responseHandler = {
  success: (res, data = {}, message = "Success", status = 200) => {
    return res.status(status).json({
      success: true,
      message,
      data: data || null,
      statusCode: status,
    });
  },
  error: (
    res,
    error = {},
    message = "An unexpected error occurred",
    status = 500
  ) => {
    let resStatus = error.status || status;
    return res.status(resStatus).json({
      success: false,
      message: message || error.message,
      error: error.code || "UNKNOWN_ERROR",
      statsCode: resStatus,
    });
  },
};

export default responseHandler;
