import express from "express";
import http from "http";
import { Server } from "socket.io";
import jwt, { decode } from "jsonwebtoken";
import dotenv from "dotenv";
import helmet from "helmet";
import cors from "cors";
import { PrismaClient as PrismaClient1 } from "../../prisma/generated/client1/index.js";
import { PrismaClient as PrismaClient2 } from "../../prisma/generated/client2/index.js";
import { verifyToken } from "../utils/jwt.js";

const prismaMasterDb = new PrismaClient1();

const prismaSubMasterDb = new PrismaClient2();

dotenv.config();

const app = express();

app.use(helmet());

app.use(
  cors({
    origin: "*", // Allow all origins (adjust as needed)
    methods: ["GET", "POST", "PUT", "DELETE"],
    // allowedHeaders: ["Content-Type"],
  })
);

// app.use(express.json());

const server = http.createServer(app);


const io = new Server(server, {
  transports: ["websocket", "polling"],
});

// authentication //

// Authentication middleware for Socket.IO connection

io.use((socket, next) => {
  // console.log(socket, "check socket s-->");
  // Get token from query parameter or headers
  const token =
    socket.handshake.query.token || socket.handshake.headers["authorization"];

  if (token) {
    const data = verifyToken(token);

    socket.user = data;
    console.log(socket.user);
    return next();
  } else {
    console.log("in else conititonss");
    return next(new Error("Authentication token is required"));
  }
});

// listen connection//

io.on("connection", (socket) => {
  const ROLE = Object.getOwnPropertyNames(socket.user)[0];
  const userId = socket?.user[ROLE].id;

  socket.on("join-room", (data) => {
    socket.join(`room:${data.userId}`);
    console.log("Room Joined : ", data.userId);
    io.to(`room:${13}`).emit("connection", "connected to socket");
  });

  socket.on("leave-room", (data) => {
    socket.join(`room:${data.userId}`);
    console.log("Room Leave : ", data.userId);
  });

  socket.join(`room:${userId}`);

  socket.on("disconnect", () => {
    console.log("User disconnected");
  });
});

server.listen(5000, () => {
  console.log("socket is listening on *:5000");
});
export default io;
