import responseHandler from "../../utils/responseHandler.js";
// import { PrismaClient } from "@prisma/client";
// import { PrismaClient as PrismaClient1 } from "../../../generated1/client1/index.js";
// import { PrismaClient as PrismaClient2 } from "../../../generated1/client2/index.js";

// import { PrismaClient as PrismaClient1 } from "../../../generated/client1/index.js";
// import { PrismaClient as PrismaClient2 } from "../../../generated/client2/index.js";
import { PrismaClient as PrismaClient1 } from "../../../prisma/generated/client1/index.js";
import { PrismaClient as PrismaClient2 } from "../../../prisma/generated/client2/index.js";
import { PrismaClient as MongoClient } from "../../../prisma/generated/mongo-client/index.js";
import _ from "lodash";
import errorCodes from "../../utils/errorCodes.js";
import moment from "moment";
import {
  capitalizedWord,
  convertKey,
  mapTaskToAssignStatus,
  projectTimefn,
  rankHistoryValues,
  safeRound,
  searchVolumeLabels,
  searchVolumeValues,
} from "../../utils/helper.js";
import { customResponse, failureResponse } from "../../utils/responseFn.js";

const prismaMasterDb = new PrismaClient1();

const prismaSubMasterDb = new PrismaClient2();

const mongoClient = new MongoClient();

// fetch domain category //

const fetchDomainCategory = async (req, res) => {
  try {
    let data = null;

    const { page = 1, limit = 50 } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    const allCategory = await prismaSubMasterDb.ProjectCategory.findMany({
      where: {
        deleted_at: null,
      },
      skip: skip,
      take: limitInt,
    });

    // Get total count for pagination info
    const totalCount = await prismaSubMasterDb.ProjectCategory.count({
      where: {
        deleted_at: null,
      },
    });
    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    data = {
      categories: allCategory,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    //if n
    // if (!newCategory) {
    //   return responseHandler.error(res,errorCodes.NOT_FOUND, "Error while fething categories.", 400);
    // }
    // Send success response with the created role data
    return responseHandler.success(
      res,
      data,
      "Catgeory fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, err);
  }
};

// const createDomain = async (req, res) => {
//   try {
//     const userData = req.user;
//     const ROLE = Object.keys(userData)[0];
//     console.log("Authenticated User Role:", ROLE);

//     const existUser = await prismaSubMasterDb.User.findFirst({
//       where: {
//         id: userData[ROLE]?.id,
//         deleted_at: null,
//       },
//       select: {
//         id: true,
//         email: true,
//         UserInfo: {
//           select: {
//             id: true,
//             role_id: true,
//             user_id: true,
//             organisation_id: true,
//           },
//         },
//       },
//     });

//     if (!existUser)
//       return customResponse(res, false, 400, {}, "User not found.");
//     console.log("User found:", existUser);

//     const {
//       category,
//       domain_name,
//       domain_url,
//       time_around,
//       member_id,
//       guide_lines = [],
//       seo_packages,
//       keywords = [],
//       locationRegionData = {},
//     } = req.body;

//     const existingCategory = await prismaSubMasterDb.ProjectCategory.findFirst({
//       where: { id: Number(category), deleted_at: null },
//     });

//     if (!existingCategory)
//       return customResponse(res, false, 400, {}, "Category not found.");

//     const projectExistsInSql = await prismaSubMasterDb.Project.findFirst({
//       where: { created_by_id: existUser?.id, domain_url , organisation_id: existUser?.organisation_id},
//     });

//     const projectExistsInMongo = await mongoClient.group.findFirst({
//       where: { fk_user_id: existUser?.id, domain_name  },
//     });

//     console.log("Project exists in SQL:", projectExistsInSql);
//     console.log("Project exists in Mongo:", projectExistsInMongo);

//     if (projectExistsInSql || projectExistsInMongo) {
//       console.warn("Project already exists in DB.");
//       return customResponse(res, false, 400, {}, "Project already exists.");
//     }

//     console.log("Project does not exist in DB.");

//     // const existingSeoPackage = await prismaSubMasterDb.seo_packages.findFirst({
//     //   where: { id: Number(seo_packages), deleted_at: null },
//     // });

//     // if (!existingSeoPackage)
//     //   return customResponse(res, false, 400, {}, "SEO package not found.");
//     // console.log("SEO Package found:", existingSeoPackage);

//     // const getProjectTime = projectTimefn(Number(time_around));
//     // const totalGuideLineCount = guide_lines.reduce(
//     //   (sum, item) => (typeof item.value === "number" ? sum + item.value : sum),
//     //   0
//     // );

//     // console.log("Project Time:", getProjectTime);
//     // console.log("Total Guidelines:", totalGuideLineCount);

//     // const createdDomain = await prismaSubMasterDb.$transaction(async (tx) => {
//     //   const domain = await tx.Project.create({
//     //     data: {
//     //       domain_name,
//     //       domain_url,
//     //       category_id: existingCategory.id,
//     //       created_by_id: existUser.id,
//     //       time_around: getProjectTime,
//     //       total_tasks_count: totalGuideLineCount,
//     //       time_around_days: time_around,
//     //       package_id: Number(seo_packages),
//     //       organisation_id: existUser.UserInfo?.organisation_id ?? null,
//     //     },
//     //   });

//     //   console.log("Domain created in SQL:", domain);

//     //   await tx.ProjectGuideLines.createMany({
//     //     data: [
//     //       {
//     //         project_id: domain.id,
//     //         guide_id: Number(seo_packages),
//     //         link_count: totalGuideLineCount,
//     //         status: 1,
//     //       },
//     //     ],
//     //   });

//     //   console.log("Project Guidelines created.");
//     //   return domain;
//     // });

//     // const lastGroup = await mongoClient.group.findFirst({
//     //   orderBy: { id_: "desc" },
//     //   select: { id_: true },
//     // });

//     // const newMongoId = (lastGroup?.id_ ?? 0) + 1;
//     // console.log("Generated Mongo Group ID:", newMongoId);

//     // const mongoGroupData = {
//     //   id_: newMongoId,
//     //   fk_user_id: existUser.id,
//     //   group_name: domain_name,
//     //   domain_name: domain_url,
//     //   project_automation_time: new Date(),
//     //   group_call_status: "INIT",
//     //   track_status: "INIT",
//     //   metric_status: "INIT",
//     //   group_call_start: new Date(),
//     //   group_call_end: new Date(),
//     //   uptrend_cnt: 0,
//     //   downtrend_cnt: 0,
//     //   keyword_difficulty: "NA",
//     //   created_date: new Date(),
//     //   updated_date: new Date(),
//     // };

//     // await mongoClient.group.create({ data: mongoGroupData });
//     // console.log("Mongo Group created:", mongoGroupData);

//     // const keywordData = {
//     //   ...locationRegionData,
//     //   fk_group_id: newMongoId,
//     //   fk_user_id: existUser.id,
//     //   domain_url,
//     // };

//     // console.log("Keyword meta prepared:", keywordData);
//     // await createKeywords(keywordData, keywords);

//     // await prismaMasterDb.Projects.create({
//     //   data: {
//     //     domain_name,
//     //     domain_url,
//     //     category_id: existingCategory.id,
//     //     created_by_id: existUser.id,
//     //     time_around: getProjectTime,
//     //     time_around_days: time_around,
//     //   },
//     // });

//     // console.log("Master DB entry created.");
//     // return customResponse(
//     //   res,
//     //   true,
//     //   200,
//     //   createdDomain,
//     //   "Project created successfully."
//     // );
//   } catch (err) {
//     console.error("createDomain error:", err);
//     return failureResponse(res, err);
//   }
// };

// const createDomain = async (req, res) => {
//   let createdDomain = null;
//   let mongoGroupCreated = false;
//   let createdKeywordIds = [];

//   try {
//     const userData = req.user;
//     const ROLE = Object.keys(userData)[0];

//     const existUser = await prismaSubMasterDb.User.findFirst({
//       where: {
//         id: userData[ROLE]?.id,
//         deleted_at: null,
//       },
//       select: {
//         id: true,
//         email: true,
//         UserInfo: {
//           select: {
//             id: true,
//             role_id: true,
//             user_id: true,
//             organisation_id: true,
//           },
//         },
//       },
//     });

//     if (!existUser)
//       return customResponse(res, false, 400, {}, "User not found.");

//     const {
//       category,
//       domain_name,
//       domain_url,
//       time_around,
//       member_id,
//       guide_lines = [],
//       seo_packages,
//     } = req.body;

//     const existingCategory = await prismaSubMasterDb.ProjectCategory.findFirst({
//       where: { id: Number(category), deleted_at: null },
//     });

//     if (!existingCategory)
//       return customResponse(res, false, 400, {}, "Category not found.");

//     const projectExistsInSql = await prismaSubMasterDb.Project.findFirst({
//       where: { created_by_id: existUser.id, domain_url },
//     });

//     const projectExistsInMongo = await mongoClient.group.findFirst({
//       where: { fk_user_id: existUser.id, domain_name },
//     });

//     if (projectExistsInSql || projectExistsInMongo) {
//       return customResponse(res, false, 400, {}, "Project already exists.");
//     }

//     const existingSeoPackage = await prismaSubMasterDb.seo_packages.findFirst({
//       where: { id: Number(seo_packages), deleted_at: null },
//     });

//     if (!existingSeoPackage)
//       return customResponse(res, false, 400, {}, "SEO package not found.");

//     const getProjectTime = projectTimefn(Number(time_around));
//     const totalGuideLineCount = guide_lines.reduce(
//       (sum, item) => (typeof item.value === "number" ? sum + item.value : sum),
//       0
//     );

//     // === SQL Transaction START ===
//     createdDomain = await prismaSubMasterDb.$transaction(async (tx) => {
//       const domain = await tx.Project.create({
//         data: {
//           domain_name,
//           domain_url,
//           category_id: existingCategory.id,
//           created_by_id: existUser.id,
//           time_around: getProjectTime,
//           total_tasks_count: totalGuideLineCount,
//           time_around_days: time_around,
//           package_id: Number(seo_packages),
//           organisation_id: existUser.UserInfo?.organisation_id ?? null,
//         },
//       });

//       await tx.ProjectGuideLines.createMany({
//         data: [
//           {
//             project_id: domain.id,
//             guide_id: Number(seo_packages),
//             link_count: totalGuideLineCount,
//             status: 1,
//           },
//         ],
//       });

//       return domain;
//     });
//     // === SQL Transaction END ===

//     // === MongoDB Group Insert ===
//     const lastGroup = await mongoClient.group.findFirst({
//       orderBy: { id_: "desc" },
//       select: { id_: true },
//     });

//     const newMongoId = (lastGroup?.id_ ?? 0) + 1;

//     const mongoGroupData = {
//       id_: newMongoId,
//       fk_user_id: existUser.id,
//       group_name: domain_name,
//       domain_name: domain_url,
//       project_automation_time: new Date(),
//       group_call_status: "INIT",
//       track_status: "INIT",
//       metric_status: "INIT",
//       group_call_start: new Date(),
//       group_call_end: new Date(),
//       uptrend_cnt: 0,
//       downtrend_cnt: 0,
//       keyword_difficulty: "NA",
//       created_date: new Date(),
//       updated_date: new Date(),
//     };

//     await mongoClient.group.create({ data: mongoGroupData });
//     mongoGroupCreated = true;

//     await prismaMasterDb.Projects.create({
//       data: {
//         domain_name,
//         domain_url,
//         category_id: existingCategory.id,
//         created_by_id: existUser.id,
//         time_around: getProjectTime,
//         time_around_days: time_around,
//       },
//     });

//     return customResponse(
//       res,
//       true,
//       200,
//       createdDomain,
//       "Project created successfully."
//     );
//   } catch (err) {
//     console.error("Error in createDomain:", err);

//     // Rollback SQL
//     if (createdDomain) {
//       try {
//         await prismaSubMasterDb.Project.delete({
//           where: { id: createdDomain.id },
//         });
//         await prismaSubMasterDb.ProjectGuideLines.deleteMany({
//           where: { project_id: createdDomain.id },
//         });
//         console.log("Rolled back SQL Project and Guidelines.");
//       } catch (rollbackErr) {
//         console.error("SQL Rollback failed:", rollbackErr);
//       }
//     }

//     // Rollback Mongo Group
//     if (mongoGroupCreated) {
//       try {
//         await mongoClient.group.delete({
//           where: {
//             domain_name: domain_url,
//             fk_user_id: userData[Object.keys(userData)[0]].id,
//           },
//         });
//         console.log("Rolled back Mongo group.");
//       } catch (mongoRollbackErr) {
//         console.error("Mongo group rollback failed:", mongoRollbackErr);
//       }
//     }

//     // Rollback Mongo Keywords
//     if (createdKeywordIds.length > 0) {
//       try {
//         await mongoClient.keyword.deleteMany({
//           where: { id_: { in: createdKeywordIds } },
//         });
//         console.log("Rolled back created Mongo keywords.");
//       } catch (keywordRollbackErr) {
//         console.error("Keyword rollback failed:", keywordRollbackErr);
//       }
//     }

//     return failureResponse(res, err);
//   }
// };

const createDomain = async (req, res) => {
  let createdDomain = null;
  let mongoGroupCreated = false;
  let createdKeywordIds = [];

  try {
    const userData = req.user;
    const ROLE = Object.keys(userData)[0];

    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE]?.id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            role_id: true,
            user_id: true,
            organisation_id: true,
          },
        },
      },
    });

    if (!existUser)
      return customResponse(res, false, 400, {}, "User not found.");

    const {
      id,
      category,
      domain_name,
      domain_url,
      time_around,
      member_id,
      guide_lines = [],
      seo_packages,
    } = req.body;



if (guide_lines?.length) {
  for (const gl of guide_lines) {

    const existGuideline = await prismaSubMasterDb.guideLines.findFirst({
      where: {
        task_name: gl?.real_key,
        deleted_at: null,
      },
    });

   //  console.log(existGuideline?.id, "existGuideline");

    if (!existGuideline) {
      return customResponse(res, false, 400, {}, "Guideline not found.");
    }
  }
}



    const existingCategory = await prismaSubMasterDb.ProjectCategory.findFirst({
      where: { id: Number(category), deleted_at: null },
    });

    if (!existingCategory)
      return customResponse(res, false, 400, {}, "Category not found.");

    const existingSeoPackage = await prismaSubMasterDb.seo_packages.findFirst({
      where: { id: Number(seo_packages), deleted_at: null },
    });

    if (!existingSeoPackage)
      return customResponse(res, false, 400, {}, "SEO package not found.");

    const getProjectTime = projectTimefn(Number(time_around));
    const totalGuideLineCount = guide_lines.reduce(
      (sum, item) => (typeof item.value === "number" ? sum + item.value : sum),
      0
    );

    // === IF ID IS 0 => CREATE ===
    if (Number(id) === 0) {
      const projectExistsInSql = await prismaSubMasterDb.Project.findFirst({
        where: { created_by_id: existUser.id, domain_url },
      });

      const projectExistsInMongo = await mongoClient.group.findFirst({
        where: { fk_user_id: existUser.id, domain_name },
      });

      if (projectExistsInSql || projectExistsInMongo) {
        return customResponse(res, false, 400, {}, "Project already exists.");
      }

      createdDomain = await prismaSubMasterDb.$transaction(async (tx) => {
        const domain = await tx.Project.create({
          data: {
            domain_name,
            domain_url,
            category_id: existingCategory.id,
            created_by_id: existUser.id,
            time_around: getProjectTime,
            total_tasks_count: totalGuideLineCount,
            time_around_days: time_around,
            package_id: Number(seo_packages),
            organisation_id: existUser.UserInfo?.organisation_id ?? null,
          },
        });

        await tx.ProjectGuideLines.createMany({
          data: [
            {
              project_id: domain.id,
              guide_id: Number(seo_packages),
              link_count: totalGuideLineCount,
              status: 1,
            },
          ],
        });

        return domain;
      });

      const lastGroup = await mongoClient.group.findFirst({
        orderBy: { id_: "desc" },
        select: { id_: true },
      });

      const newMongoId = (lastGroup?.id_ ?? 0) + 1;

      await mongoClient.group.create({
        data: {
          id_: newMongoId,
          fk_user_id: existUser.id,
          group_name: domain_name,
          domain_name: domain_url,
          project_automation_time: new Date(),
          group_call_status: "INIT",
          track_status: "INIT",
          metric_status: "INIT",
          group_call_start: new Date(),
          group_call_end: new Date(),
          uptrend_cnt: 0,
          downtrend_cnt: 0,
          keyword_difficulty: "NA",
          created_date: new Date(),
          updated_date: new Date(),
        },
      });

      mongoGroupCreated = true;

      await prismaMasterDb.Projects.create({
        data: {
          domain_name,
          domain_url,
          category_id: existingCategory.id,
          created_by_id: existUser.id,
          time_around: getProjectTime,
          time_around_days: time_around,
        },
      });

      return customResponse(
        res,
        true,
        200,
        createdDomain,
        "Project created successfully."
      );
    }

    // === ELSE => UPDATE LOGIC ===
    const existingProject = await prismaSubMasterDb.Project.findFirst({
      where: { id: Number(id), deleted_at: null },
    });

    if (!existingProject) {
      return customResponse(res, false, 404, {}, "Project not found.");
    }

    const updatedDomain = await prismaSubMasterDb.$transaction(async (tx) => {
      const updatedProject = await tx.Project.update({
        where: { id: Number(id) },
        data: {
          domain_name,
          domain_url,
          category_id: existingCategory?.id,
          time_around: getProjectTime,
          time_around_days: time_around,
          package_id: Number(seo_packages),
          total_tasks_count: totalGuideLineCount,
          updated_at: new Date(),
        },
      });

      await tx.ProjectGuideLines.deleteMany({
        where: { project_id: Number(id) },
      });

      await tx.ProjectGuideLines.createMany({
        data: [
          {
            project_id: Number(id),
            guide_id: Number(seo_packages),
            link_count: totalGuideLineCount,
            status: 1,
          },
        ],
      });

      return updatedProject;
    });

    // === Safe update in Master DB ===
    const existingMasterProject = await prismaMasterDb.Projects.findFirst({
      where: { domain_url },
    });

    if (existingMasterProject) {
      await prismaMasterDb.Projects.update({
        where: { domain_url },
        data: {
          domain_name,
          category_id: existingCategory?.id,
          time_around: getProjectTime,
          time_around_days: time_around,
          updated_at: new Date(),
        },
      });
    }

    // === Safe update in MongoDB ===
    // First, fetch the document using domain_name
    const existingMongoGroup = await mongoClient.group.findFirst({
      where: { domain_name: existingProject.domain_url },
      select: { id: true }, // Fetch the unique ID
    });

    // Then safely update using the ID
    if (existingMongoGroup) {
      await mongoClient.group.update({
        where: { id: existingMongoGroup.id }, // Use the ObjectId string
        data: {
          group_name: domain_name,
          domain_name: domain_url,
          updated_date: new Date(),
        },
      });
    }

    return customResponse(
      res,
      true,
      200,
      updatedDomain,
      "Project updated successfully."
    );
  } catch (err) {
    console.error("Error in createDomain:", err);

    if (createdDomain) {
      try {
        await prismaSubMasterDb.Project.delete({
          where: { id: createdDomain.id },
        });
        await prismaSubMasterDb.ProjectGuideLines.deleteMany({
          where: { project_id: createdDomain.id },
        });
        console.log("Rolled back SQL Project and Guidelines.");
      } catch (rollbackErr) {
        console.error("SQL Rollback failed:", rollbackErr);
      }
    }

    if (mongoGroupCreated) {
      try {
        await mongoClient.group.delete({
          where: {
            domain_name: req.body.domain_url,
            fk_user_id: userData[Object.keys(userData)[0]].id,
          },
        });
        console.log("Rolled back Mongo group.");
      } catch (mongoRollbackErr) {
        console.error("Mongo group rollback failed:", mongoRollbackErr);
      }
    }

    if (createdKeywordIds.length > 0) {
      try {
        await mongoClient.keyword.deleteMany({
          where: { id_: { in: createdKeywordIds } },
        });
        console.log("Rolled back created Mongo keywords.");
      } catch (keywordRollbackErr) {
        console.error("Keyword rollback failed:", keywordRollbackErr);
      }
    }

    return failureResponse(res, err);
  }
};

const addKeywords = async (req, res) => {
  const userData = req.user;
  const ROLE = Object.keys(userData)[0];

  const existUser = await prismaSubMasterDb.User.findFirst({
    where: {
      id: userData[ROLE]?.id,
      deleted_at: null,
    },
    select: {
      id: true,
      email: true,
      UserInfo: {
        select: {
          id: true,
          role_id: true,
          user_id: true,
          organisation_id: true,
        },
      },
    },
  });

  if (!existUser) return customResponse(res, false, 400, {}, "User not found.");

 //  console.log("existUser:", existUser);

  const {
    domain_url,
    domain_name,
    fk_group_id,
    location,
    isocode,
    region,
    language,
    language_code,
    location_code,
    keywords,
  } = req.body;

  // console.log("request body:", req.body);

  const createdKeywords = [];

  for (const keywordText of keywords) {
    if (!keywordText || typeof keywordText !== "string") {
      // console.warn("Skipping invalid keyword:", keywordText);
      continue;
    }

    const existing = await mongoClient.keyword.findFirst({
      where: {
        keyword: keywordText,
        fk_group_id: fk_group_id,
        site_url: domain_url,
        location,
      },
      select: { id_: true },
    });

    if (existing) {
      // console.log(`Keyword "${keywordText}" already exists. Skipping.`);
      continue;
    }

    const lastKeyword = await mongoClient.keyword.findFirst({
      orderBy: { id_: "desc" },
      select: { id_: true },
    });

    const newId = (lastKeyword?.id_ ?? 0) + 1;

    const today = new Date();

    const newKeyword = {
      id_: newId,
      // Ensure this is an Int and not a string
      fk_group_id: fk_group_id,
      fk_user_id: existUser.id,
      keyword: keywordText,
      site_url: domain_url,
      target: domain_url,
      platform: "Desktop",
      exactdomain: false,
      location: location,
      isocode: isocode,
      region: region,
      language: language,
      language_code: language_code,
      location_code: location_code,

      ranknow: 0,
      search_volume: "NA",
      keyword_difficulty: "NA",
      search_intent: "NA",
      cpc: "NA",
      traffic: "NA",
      ranked_url: "NA",
      rank_trend: "NA",
      rank: [],
      rank_history: [],
      search_volume_data: [],
      keyword_suggestions: [],

      track_status: "INIT",
      metric_status: "INIT",
      rank_sincestart: 0,
      top_rank: 0,

      created_date: today,
      updated_date: today,
      modified_date: today,
      lastranked_date: today,

      dayval: 0,
      weekval: 0,
      monthval: 0,
      halfmonthval: 0,

      daymark: "",
      weekmark: "",
      monthmark: "",
      halfmonthmark: "-",
      status_from_start: "-",

      auto_refresh_count: 0,
      auto_call_status: "done",

      crawlurl: "-",
      page_uuid_url: "-",
      page_uuid: "-",
    };

    const savedKeyword = await mongoClient.keyword.create({ data: newKeyword });
    createdKeywords.push(savedKeyword);

    // console.log("Keyword created:", savedKeyword);
  }

  return customResponse(
    res,
    true,
    200,
    createdKeywords,
    "Keywords added successfully."
  );
};

const deleteKeyword = async (req, res) => {
  try {
    const userData = req.user;
    const ROLE = Object.keys(userData)[0];

    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE]?.id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            role_id: true,
            user_id: true,
            organisation_id: true,
          },
        },
      },
    });

    if (!existUser)
      return customResponse(res, false, 400, {}, "User not found.");

    const { keyword_id } = req.query;
    // console.log("keyword_id:", keyword_id);
    const deletedKeyword = await mongoClient.keyword.delete({
      where: {
        id: keyword_id,
      },
    });

   //  console.log("deletedKeyword:", deletedKeyword);

    return customResponse(res, true, 200, {}, "Keyword deleted successfully.");
  } catch (error) {
    console.error("Error deleting keyword:", error);
    return customResponse(res, false, 500, {}, "Error deleting keyword.");
  }
};

// Edit domain //
const editDomain = async (req, res) => {
  try {
    let data;

    const { category_id, domain_name, domain_url, time_around, domain_id } =
      req.body;

    const existingCategory = await prismaSubMasterDb.ProjectCategory.findFirst({
      where: {
        id: category_id, // Check if the role name already exists in the database
      },
    });

    // If the role already exists, return a conflict error
    if (!existingCategory) {
      return responseHandler.error(
        res,
        errorCodes.CATEGORY.code,
        errorCodes.CATEGORY.message,
        400
      );
    }

    const updatedDomain = await prismaSubMasterDb.Project.update({
      where: {
        id: domain_id, // Use the existing record's id or any unique identifier
      },
      data: {
        domain_name: domain_name, // New domain name
        domain_url: domain_url, // New domain URL
        category_id: category_id, // Updated category id
        time_around: new Date(time_around), // Updated time_around
      },
    });

    data = updatedDomain;

    return responseHandler.success(
      res,
      data,
      "domain added successfully.",
      200
    );
  } catch (err) {
    return responseHandler.error(res, errorCodes.BAD_REQUEST, err.message, 500);
  }
};

// all mongo projects //

const fetchAllMongoProjects = async (req, res) => {
  try {
    let data = null;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
      },
      select: {
        id: true,
        create_by: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });
    console.log(existUser, "exist suser -->");

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { page_no = 1, limit = 21, search_text = "", grpid = "" } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;
    let userDomain = "";
    let totalCount = 0;
    if (existUser?.UserInfo?.role_id === 1) {
      userDomain = await mongoClient.group.findMany({
        // where: {
        //   domain_name: {
        //     contains: search_text,
        //     mode: "insensitive", // Optional: for case-insensitive matching
        //   },
        // },
        skip: skip,
        take: limitInt,
        orderBy: {
          created_date: "desc",
        },
      });

      totalCount = await mongoClient.group.count({});
    } else {
      userDomain = await mongoClient.group.findMany({
        // where: {
        //   domain_name: {
        //     contains: search_text,
        //     mode: "insensitive", // Optional: for case-insensitive matching
        //   },
        // },
        skip: skip,
        take: limitInt,
        orderBy: {
          created_date: "desc",
        },
      });

      totalCount = await mongoClient.group.count({});
    }

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    data = {
      domains: userDomain,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };
    // console.log(data,"data fetching time")
    return responseHandler.success(
      res,
      data,
      "domain fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err, "errore");
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

// fetch all compititors //

const fetchAllCompititors = async (req, res) => {
  try {
    let data = null;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
      },
      select: {
        id: true,
        create_by: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });
    console.log(existUser, "exist suser -->");

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { page_no = 1, limit = 21, search_text = "", grpid = "" } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;
    let allCompititiors = "";
    let totalCount = 0;
    if (existUser?.UserInfo?.role_id === 1) {
      allCompititiors = await mongoClient.competitors.findMany({
        // where: {
        //   domain_name: {
        //     contains: search_text,
        //     mode: "insensitive", // Optional: for case-insensitive matching
        //   },
        // },
        skip: skip,
        take: limitInt,
        orderBy: {
          created_date: "desc",
        },
      });

      totalCount = await mongoClient.competitors.count({});
    } else {
      allCompititiors = await mongoClient.competitors.findMany({
        // where: {
        //   domain_name: {
        //     contains: search_text,
        //     mode: "insensitive", // Optional: for case-insensitive matching
        //   },
        // },
        skip: skip,
        take: limitInt,
        orderBy: {
          created_date: "desc",
        },
      });

      totalCount = await mongoClient.competitors.count({});
    }

    // Get total count for pagination info

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // console.log(totalLinksCount, "LOOPPEPEPE", dailyLinkCount);
    // Prepare the response data

    data = {
      domains: allCompititiors,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };
    // console.log(data,"data fetching time")
    return responseHandler.success(
      res,
      data,
      "domain fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err, "errore");
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

// fetch all keywords //

const fetchAllKewords = async (req, res) => {
  try {
    let data = null;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
      },
      select: {
        id: true,
        create_by: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const {
      page_no = 1,
      limit = 10,
      search_text = "",
      grpid = "",
      compid = "",
    } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    let whereClause = {};
    if (grpid && !isNaN(parseInt(grpid))) {
      whereClause.fk_group_id = parseInt(grpid);
    }

    if (search_text) {
      whereClause.keyword = {
        contains: search_text,
        mode: "insensitive",
      };
    }

    let competitorData = null;
    if (compid) {
      competitorData = await mongoClient.competitors.findUnique({
        where: { id: compid },
      });
    } else {
      // Find the first competitor in this group, if compid not provided
      competitorData = await mongoClient.competitors.findFirst({
        where: {
          fk_group_id: whereClause.fk_group_id,
        },
      });
    }

    const rankMapping = {};
    if (competitorData && Array.isArray(competitorData.keywords)) {
      for (const item of competitorData.keywords) {
        if (item.keyword != null && typeof item.rank !== "undefined") {
          rankMapping[item.keyword] = item.rank;
        }
      }
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;
    let allKeywords = "";
    let totalCount = 0;
    //     if (existUser?.UserInfo?.role_id === 1) {
    //       allKeywords = await mongoClient.keyword.findMany({
    //         where: whereClause,
    //         skip: skip,
    //         take: limitInt,
    //         orderBy: {
    //           created_date: "desc",
    //         },
    //       });

    //  // 11. Build the optimized list
    //     const optimizedKeywordList = allKeywords.map((kw) => {
    //       const matchedRank =
    //         competitorData && rankMapping[kw.keyword] !== undefined
    //           ? rankMapping[kw.keyword]
    //           : ">100";

    //       // Extract labels/values for volume & rank history
    //       const searchVolLabels = searchVolumeLabels(kw.search_volume_data);
    //       const searchVolValues = searchVolumeValues(kw.search_volume_data);
    //       const rankHistoryVals = rankHistoryValues(kw.rank_history);

    //       return {
    //         // Spread all original fields:
    //         id: kw.id,
    //         fk_user_id: kw.fk_user_id,
    //         fk_group_id: kw.fk_group_id,
    //         site_url: kw.site_url,
    //         target: kw.target,
    //         keyword: kw.keyword,
    //         rank: kw.rank,
    //         ranked_url: kw.ranked_url,
    //         ranknow: kw.ranknow,
    //         search_volume: kw.search_volume,
    //         search_volume_data: kw.search_volume_data,
    //         search_intent: capitalizedWord(kw.search_intent),
    //         traffic: safeRound(kw.traffic),
    //         keyword_difficulty: safeRound(kw.keyword_difficulty),
    //         cpc: safeRound(kw.cpc),
    //         track_status: kw.track_status,
    //         metric_status: kw.metric_status,
    //         rank_history: kw.rank_history,
    //         created_date: kw.created_date,

    //         // Added/derived fields:
    //         matched_rank: matchedRank,
    //         search_volume_monthly_labels: searchVolLabels,
    //         search_volume_monthly_values: searchVolValues,
    //         rank_history_daily_labels:
    //           Array.isArray(kw.rank_history) && kw.rank_history.length
    //             ? kw.rank_history.map((item) => item.date ?? "")
    //             : [],
    //         rank_history_daily_values: rankHistoryVals,
    //       };
    //     });

    //       totalCount = await mongoClient.keyword.count({});
    //     }
    //
    //  else if (existUser?.UserInfo?.role_id == 2) {

    allKeywords = await mongoClient.keyword.findMany({
      where: whereClause,
      skip: skip,
      take: limitInt,
      orderBy: {
        created_date: "desc",
      },
    });

    const optimizedKeywordList = allKeywords.map((kw) => {
      const matchedRank =
        competitorData && rankMapping[kw.keyword] !== undefined
          ? rankMapping[kw.keyword]
          : ">100";

      // Extract labels/values for volume & rank history
      const searchVolLabels = searchVolumeLabels(kw.search_volume_data);
      const searchVolValues = searchVolumeValues(kw.search_volume_data);
      const rankHistoryVals = rankHistoryValues(kw.rank_history);

      return {
        // Spread all original fields:
        id: kw.id,
        fk_user_id: kw.fk_user_id,
        fk_group_id: kw.fk_group_id,
        site_url: kw.site_url,
        target: kw.target,
        keyword: kw.keyword,
        rank: kw.rank,
        ranked_url: kw.ranked_url,
        ranknow: kw.ranknow,
        search_volume: kw.search_volume,
        search_volume_data: kw.search_volume_data,
        search_intent: capitalizedWord(kw.search_intent),
        traffic: safeRound(kw.traffic),
        keyword_difficulty: safeRound(kw.keyword_difficulty),
        cpc: safeRound(kw.cpc),
        track_status: kw.track_status,
        metric_status: kw.metric_status,
        rank_history: kw.rank_history,
        created_date: kw.created_date,

        // Added/derived fields:
        matched_rank: matchedRank,
        search_volume_monthly_labels: searchVolLabels,
        search_volume_monthly_values: searchVolValues,
        rank_history_daily_labels:
          Array.isArray(kw.rank_history) && kw.rank_history.length
            ? kw.rank_history.map((item) => item.date ?? "")
            : [],
        rank_history_daily_values: rankHistoryVals,
      };
    });

    totalCount = await mongoClient.keyword.count({});
    // }

    // else if (existUser?.UserInfo?.role_id == 3) {

    // totalCount = await mongoClient.keyword.count({});
    // }

    // Get total count for pagination info

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // console.log(totalLinksCount, "LOOPPEPEPE", dailyLinkCount);
    // Prepare the response data

    // console.log(allKeywords,"logged--->")

    data = {
      keywords: optimizedKeywordList,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };
    // console.log(data,"data fetching time")
    return responseHandler.success(
      res,
      data,
      "domain fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err, "errore");
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

//fetch all domain //
const fetchAllDomain = async (req, res) => {
  try {
    let data = null;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
      },
      select: {
        id: true,
        create_by: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { page_no = 1, limit = 21, search_text = "" } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    let userDomain;
    let totalLinksCount;
    let dailyLinkCount;
    let projectData;
    let duplicateLinkCount;
    let today = moment().format("YYYY-MM-DD");

    let totalCount = 0;
    if (existUser?.UserInfo?.role_id === 1) {
      userDomain = await prismaSubMasterDb.Project.findMany({
        where: {
          deleted_at: null,
          domain_name: {
            contains: search_text,
            mode: "insensitive", // Optional: for case-insensitive matching
          },
        },
        skip: skip,
        take: limitInt,
        orderBy: {
          created_at: "desc",
        },
        include: {
          backlinks: {
            where: {
              deleted_at: null, // Only include backlinks where deleted_at is null
            },
            // ProjectGuideLines: {
            //   where: {
            //     deleted_at: null,
            //   },
            // },
          },
        },
      });

      projectData = userDomain.map((project) => {
        // Total backlinks count for each project
        totalLinksCount = project.backlinks.length;

        // Get today's date in YYYY-MM-DD format

        dailyLinkCount = project.backlinks.reduce((acc, backlink) => {
          const createdAtDate = moment(backlink.created_at).format(
            "YYYY-MM-DD"
          ); // Get date part of `created_at`
          if (createdAtDate === today) {
            // Check if the backlink was created today
            acc += 1; // Increment count for today's backlinks
          }
          return acc;
        }, 0);

        // Count duplicate backlinks based on 'refering_domain' or 'backlink_duplicate' being true
        duplicateLinkCount = project.backlinks.reduce((acc, backlink) => {
          if (backlink.refering_domain || backlink.backlink_duplicate) {
            acc += 1; // Increment count if either field is true (indicating it's a duplicate)
          }
          return acc;
        }, 0);

        // Return the result for this project
        return {
          id: project.id,
          category_id: project.category_id,
          created_by_id: project.created_by_id,
          domain_name: project.domain_name,
          totalLinksCount,
          dailyLinkCount,
          duplicateLinkCount,
        };
      });

      totalCount = await prismaSubMasterDb.Project.count({
        where: {
          deleted_at: null,
        },
      });
    } else if (existUser?.UserInfo?.role_id == 2) {
      userDomain = await prismaSubMasterDb.Project.findMany({
        where: {
          deleted_at: null,
          domain_name: {
            contains: search_text,
            mode: "insensitive", // Optional: for case-insensitive matching
          },

          OR: [
            // Case 1: Organisation created the project
            { created_by_id: existUser.id, organisation_id: existUser.id },
            // Case 2: Project belongs to the organisation
            { organisation_id: existUser.id },
            // Case 3: User is a member
            { ProjectMember: { some: { assign_to: existUser.id } } },
          ],
        },
        include: {
          ProjectGuideLines: {
            select: {
              GuideLines: {
                select: {
                  id: true,
                  task_name: true,
                  uploaded_by: true,
                },
              },
            },
          },
          ProjectPackage: {
            select: {
              id: true,
              status: true,
              title: true,
            },
          },
          ProjectMember: true,
          backlinks: {
            where: {
              deleted_at: null, // Only include backlinks where deleted_at is null
            },
          },
        },
        orderBy: {
          created_at: "desc",
        },
        skip: skip,
        take: limitInt,
      });
    } else if (existUser?.UserInfo?.role_id == 3) {
      userDomain = await prismaSubMasterDb.Project.findMany({
        where: {
          deleted_at: null,
          domain_name: {
            contains: search_text,
            mode: "insensitive",
          },
          OR: [
            // Case 1: Organisation created the project
            { created_by_id: existUser.id },
            // Case 2: Project belongs to the organisation
            // { organisation_id: existUser.id },
            // Case 3: User is a member
            { ProjectMember: { some: { assign_to: existUser.id } } },
          ],
        },
        include: {
          ProjectGuideLines: {
            include: {
              GuideLineId: true,
            },
            // where: {
            //   deleted_at: null,
            // },
          },
          ProjectPackage: true,
          ProjectMember: true, // Fetch project members
          backlinks: {
            where: {
              deleted_at: null, // Only include backlinks where deleted_at is null
            },
          },
        },
        orderBy: {
          created_at: "desc",
        },
        skip: skip,
        take: limitInt,
      });

      projectData = userDomain.map((project) => {
        // Total backlinks count for each project
        totalLinksCount = project.backlinks.length;

        // Get today's date in YYYY-MM-DD format

        dailyLinkCount = project.backlinks.reduce((acc, backlink) => {
          const createdAtDate = moment(backlink.created_at).format(
            "YYYY-MM-DD"
          ); // Get date part of `created_at`
          if (createdAtDate === today) {
            // Check if the backlink was created today
            acc += 1; // Increment count for today's backlinks
          }
          return acc;
        }, 0);

        // Count duplicate backlinks based on 'refering_domain' or 'backlink_duplicate' being true
        duplicateLinkCount = project.backlinks.reduce((acc, backlink) => {
          if (backlink.refering_domain || backlink.backlink_duplicate) {
            acc += 1; // Increment count if either field is true (indicating it's a duplicate)
          }
          return acc;
        }, 0);

        // Return the result for this project
        return {
          id: project.id,
          category_id: project.category_id,
          created_by_id: project.created_by_id,
          domain_name: project.domain_name,
          totalLinksCount,
          dailyLinkCount,
          duplicateLinkCount,
        };
      });

      totalCount = await prismaSubMasterDb.Project.count({
        where: {
          deleted_at: null,
          // created_by_id: existUser.id,
          OR: [
            { created_by_id: existUser.id }, // User created the project
            { ProjectMember: { some: { assign_to: existUser.id } } }, // User is added as a member
          ],
        },
      });
    } else if (existUser?.UserInfo?.role_id == 4) {
      userDomain = await prismaSubMasterDb.Project.findMany({
        where: {
          deleted_at: null,
          domain_name: {
            contains: search_text,
            mode: "insensitive",
          },
          OR: [
            // Case 1: Organisation created the project
            { created_by_id: existUser.id },
            // Case 2: Project belongs to the organisation
            // { organisation_id: existUser.id },
            // Case 3: User is a member
            { ProjectMember: { some: { assign_to: existUser.id } } },
          ],
        },
        include: {
          ProjectGuideLines: {
            include: {
              GuideLineId: true,
            },
            // where: {
            //   deleted_at: null,
            // },
          },
          ProjectPackage: true,
          ProjectMember: true, // Fetch project members
          backlinks: {
            where: {
              deleted_at: null, // Only include backlinks where deleted_at is null
            },
          },
        },
        orderBy: {
          created_at: "desc",
        },
        skip: skip,
        take: limitInt,
      });

      projectData = userDomain.map((project) => {
        // Total backlinks count for each project
        totalLinksCount = project.backlinks.length;

        // Get today's date in YYYY-MM-DD format

        dailyLinkCount = project.backlinks.reduce((acc, backlink) => {
          const createdAtDate = moment(backlink.created_at).format(
            "YYYY-MM-DD"
          ); // Get date part of `created_at`
          if (createdAtDate === today) {
            // Check if the backlink was created today
            acc += 1; // Increment count for today's backlinks
          }
          return acc;
        }, 0);

        // Count duplicate backlinks based on 'refering_domain' or 'backlink_duplicate' being true
        duplicateLinkCount = project.backlinks.reduce((acc, backlink) => {
          if (backlink.refering_domain || backlink.backlink_duplicate) {
            acc += 1; // Increment count if either field is true (indicating it's a duplicate)
          }
          return acc;
        }, 0);

        // Return the result for this project
        return {
          id: project.id,
          category_id: project.category_id,
          created_by_id: project.created_by_id,
          domain_name: project.domain_name,
          totalLinksCount,
          dailyLinkCount,
          duplicateLinkCount,
        };
      });

      totalCount = await prismaSubMasterDb.Project.count({
        where: {
          deleted_at: null,
          // created_by_id: existUser.id,
          OR: [
            { created_by_id: existUser.id }, // User created the project
            { ProjectMember: { some: { assign_to: existUser.id } } }, // User is added as a member
          ],
        },
      });
    } else {
      userDomain = await prismaSubMasterDb.Project.findMany({
        where: {
          domain_name: {
            contains: search_text,
            mode: "insensitive",
          },
          ProjectMember: {
            some: {
              assign_to: existUser.id,
              deleted_at: null,
            },
          },
        },
        orderBy: {
          created_at: "desc",
        },
        include: {
          backlinks: true,
          // projectUser: true, // Optional if you need ProjectUser data
        },
      });

      totalCount = userDomain.length;
    }

    // Get total count for pagination info

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // console.log(totalLinksCount, "LOOPPEPEPE", dailyLinkCount);
    // Prepare the response data

    data = {
      domains: userDomain,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };
    // console.log(data,"data fetching time")
    return responseHandler.success(
      res,
      data,
      "domain fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err, "errore");
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

//

// single domain details //
// const domainDetail = async (req, res) => {
//   try {
//     let data = {};
//     const { id } = req.params;
//     const domainExists = await prismaSubMasterDb.Project.findUnique({
//       where: {
//         id: Number(id),
//       },
//     });

//     if (!domainExists) {
//       return responseHandler.error(res, errorCodes.DOMAIN, "Domain not found");
//     }

//     data = domainExists;

//     return responseHandler.success(res, data, "success", 200);
//   } catch (err) {
//     return responseHandler.error(res, errorCodes.BAD_REQUEST, err.message, 500);
//   }
// };

// assign project to user //
const assignProject = async (req, res) => {
  try {
    const { user_ids, project_id } = req.body;

    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    // let insertedData = user_ids.map((item) => ({
    //   project_id: project_id,
    //   assign_by: existUser.id,
    //   assign_to: item,
    //   status: true,
    // }));

    // const alignUser = await prismaSubMasterDb.ProjectUser.createMany({
    //   data: insertedData,
    // });

    const existingUsers = await prismaSubMasterDb.ProjectUser.findMany({
      where: { project_id: project_id },
      select: { assign_to: true, deleted_at: true },
    });

    // Extract existing user IDs from the table
    const existingUserIds = existingUsers.map((user) => user.assign_to);

    // Find users that are **newly added**
    const newUsers = user_ids.filter((id) => !existingUserIds.includes(id));

    // Find users that are **removed from selection**
    const removedUsers = existingUserIds.filter((id) => !user_ids.includes(id));

    // Find users that were **previously deleted but now reselected**
    const reactivatedUsers = existingUsers
      .filter(
        (user) => user.deleted_at !== null && user_ids.includes(user.assign_to)
      )
      .map((user) => user.assign_to);

    // **1️⃣ Insert new users**
    if (newUsers.length > 0) {
      const insertedData = newUsers.map((id) => ({
        project_id: project_id,
        assign_by: existUser.id,
        assign_to: id,
        status: true,
      }));

      await prismaSubMasterDb.ProjectUser.createMany({ data: insertedData });
    }

    // **2️⃣ Soft-delete removed users**
    if (removedUsers.length > 0) {
      await prismaSubMasterDb.ProjectUser.updateMany({
        where: {
          project_id: project_id,
          assign_to: { in: removedUsers },
        },
        data: { deleted_at: new Date() },
      });
    }

    // ** Restore reactivated users**
    if (reactivatedUsers.length > 0) {
      await prismaSubMasterDb.ProjectUser.updateMany({
        where: {
          project_id: project_id,
          assign_to: { in: reactivatedUsers },
        },
        data: { deleted_at: null },
      });
    }
    return responseHandler.success(res, {}, "Member added successfully.", 200);
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

// project details //
const projectDetails = async (req, res) => {
  try {
    let data;
    console.log("enereyre here");
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            role_id: true,
            organisation_id: true,
            user_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    console.log(existUser, "exists user");
    const { id } = req.params;

    const today = new Date(); // Get today's date

    // Get the start of the day and the end of the day for today
    const startOfDay = new Date(today.setHours(0, 0, 0, 0)); // Set to 00:00 AM
    const endOfDay = new Date(today.setHours(23, 59, 59, 999));

    // daily links //
    const existProject = await prismaSubMasterDb.Project.findFirst({
      where: {
        id: parseInt(id),
        deleted_at: null,
        // Assuming project_id is a number
      },
      select: {
        id: true,
        time_around: true,
        time_around_days: true,
        created_at: true,
        total_tasks_count: true,
        domain_name: true,
        backlinks: {
          where: {
            created_at: {
              gte: startOfDay,
              lte: endOfDay,
            },
          },
          select: {
            id: true,
            link_url: true,
            project_id: true,
          },
        },
      },
    });

    if (!existProject) {
      return customResponse(res, false, 400, {}, "Project not found.");
    }

    const { created_at, time_around } = existProject;
    const startDate = new Date(created_at); // Explicitly create a Date object

    const lastDate = new Date(time_around);

    console.log(time_around, "time around checking");

    // backlinks completed counts  //
    const backlinkCounts = await prismaSubMasterDb.Backlink.groupBy({
      by: ["link_category"],
      where: {
        project_id: existProject.id,
        deleted_at: null,
        created_at: {
          gte: startDate,
          lte: lastDate,
        },
      },
      _count: {
        link_category: true,
      },
    });

    const completeLinksCount = backlinkCounts.map((item) => ({
      link_category_id: item.link_category,
      completed: item._count.link_category,
    }));

    // Count the backlinks where created_at is between project.created_at and project.created_at + time_around
    const backLinkCompelted = await prismaSubMasterDb.Backlink.count({
      where: {
        project_id: existProject.id,
        created_at: {
          gte: created_at, // greater than or equal to project.created_at
          lte: lastDate, // less than or equal to project.created_at + time_around (in milliseconds)
        },
      },
    });

    // Count the number of backlinks created today
    const totalBacklinksToday = existProject.backlinks.length;

    // total links //
    const totalBacklinks = await prismaSubMasterDb.Backlink.count({
      where: {
        deleted_at: null,
        project_id: Number(id),
      },
    });

    // duplicate links //
    const duplicateLinks = await prismaSubMasterDb.Project.findFirst({
      where: {
        id: Number(id),
        deleted_at: null,
        // Assuming project_id is a number
      },
      include: {
        backlinks: {
          where: {
            deleted_at: null,
            backlink_duplicate: true,
          },
        },
      },
    });

    const duplicateCount = duplicateLinks?.backlinks._count || 0;

    data = {
      details: existProject,
      total_backlinks: totalBacklinks,
      total_duplicate: duplicateCount,
      daily_links: totalBacklinksToday,
      completed_task_count: backLinkCompelted,
      completeGuideLink: completeLinksCount,
    };

    return responseHandler.success(
      res,
      data,
      "Details fetched successfully.",
      200
    );
    // console.log(totalBacklinks, "and", totalBacklinksToday);
  } catch (err) {
    console.log(err);
  }
};

// projectGuideLines completed //
const projectGuideLineDetails = async (req, res) => {
  try {
    let data;

    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
    });

    if (!existUser) {
      return responseHandler.error(
        res,
        errorCodes.USER_NOT_EXIST,
        errorCodes.USER_NOT_EXIST,
        400
      );
    }

    const { id } = req.params;

    // const today = new Date(); // Get today's date

    // Get the start of the day and the end of the day for today
    // const startOfDay = new Date(today.setHours(0, 0, 0, 0)); // Set to 00:00 AM
    // const endOfDay = new Date(today.setHours(23, 59, 59, 999));

    // daily links //
    const existProject = await prismaSubMasterDb.Project.findUnique({
      where: {
        id: Number(id),
        deleted_at: null,
      },

      include: {
        ProjectGuideLines: {
          where: {
            deleted_at: null,
            project_id: Number(id),
          },
          include: {
            GuideLineId: {
              select: {
                id: true,
                task_name: true,
              },
            },
          },
        },
      },
    });

    if (!existProject) {
      return responseHandler.error(res, "Project not found", 404);
    }

    const { created_at, time_around } = existProject;
    const startDate = new Date(created_at); // Explicitly create a Date object

    const lastDate = new Date(time_around);

    // backlinks completed counts  //
    const backlinkCounts = await prismaSubMasterDb.Backlink.groupBy({
      by: ["link_category"],
      where: {
        project_id: existProject.id,
        deleted_at: null,
        created_at: {
          gte: startDate,
          lte: lastDate,
        },
      },
      _count: {
        link_category: true,
      },
    });

    const completeLinksCount = backlinkCounts.map((item) => ({
      link_category_id: item.link_category,
      completed: item._count.link_category,
    }));

    // Count the backlinks where created_at is between project.created_at and project.created_at + time_around
    const backLinkCompelted = await prismaSubMasterDb.Backlink.count({
      where: {
        project_id: existProject.id,
        created_at: {
          gte: created_at, // greater than or equal to project.created_at
          lte: lastDate, // less than or equal to project.created_at + time_around (in milliseconds)
        },
      },
    });

    const guideLineWithCompletion = existProject.ProjectGuideLines.map((pg) => {
      const match = completeLinksCount.find(
        (c) => c.link_category_id === pg.guide_id
      );

      return {
        guide_id: pg.guide_id,
        task_name: pg.GuideLineId?.task_name || null,
        link_count: pg.link_count,
        completed: match?.completed || 0,
      };
    });

    data = {
      details: existProject,
      completed_task_count: backLinkCompelted,
      completeGuideLink: guideLineWithCompletion,
    };

    return responseHandler.success(
      res,
      data,
      "Details fetched successfully.",
      200
    );
    // console.log(totalBacklinks, "and", totalBacklinksToday);
  } catch (err) {
    console.log(err);
  }
};

// fetch project packages//

const fetchProjectsPackages = async (req, res) => {
  try {
    let data = {};

    const userData = req.user;
    const ROLE = Object.getOwnPropertyNames(userData)[0];

    const { project_id } = req.params;

    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const existProject = await prismaSubMasterDb.Project.findFirst({
      where: {
        id: Number(project_id),
        deleted_at: null,
      },
      select: {
        id: true,
        domain_name: true,
        ProjectPackage: {
          select: {
            package_features: true,
          },
        },
        backlinks: {
          select: {
            id: true,
            link_category: true,
          },
        },
      },
    });

    if (!existProject) {
      return customResponse(res, false, 400, {}, "Project not found.");
    }

    console.log(
      existProject?.ProjectPackage?.package_features,
      "PACKAGE FEATURES====>"
    );
    const categoriesMapId = existProject?.backlinks.map(
      (item) => item.link_category
    );
    console.log(existProject?.backlinks, "EXIST PROJECT---->");

    const fetchGuideLine = await prismaSubMasterDb.backlink.findMany({
      where: {
        deleted_at: null,
        link_category: {
          in: categoriesMapId,
        },
      },
      select: {
        LinksCategories: {
          select: {
            id: true,
            task_name: true,
          },
        },
      },
    });

    console.log(fetchGuideLine, "fetch guide line id");
    // Step 2: Group by task_name in JavaScript
    const grouped = fetchGuideLine.reduce((acc, item) => {
      const taskName = item.LinksCategories?.task_name;
      if (!taskName) return acc;

      if (!acc[taskName]) {
        acc[taskName] = { task_name: taskName, count: 0 };
      }

      acc[taskName].count += 1;
      return acc;
    }, {});

    // Step 3: Convert object to array
    const resultArray = Object.values(grouped);

    console.log(resultArray, "result arrays");

    const cleanedFeatures = existProject?.ProjectPackage?.package_features.map(
      (feature) =>
        _.omit(feature, [
          "created_at",
          "updated_at",
          "id",
          "status",
          "deleted_at",
          "package_id",
        ]) // list unwanted fields here
    );

    let resultData = mapTaskToAssignStatus(resultArray, cleanedFeatures);

    console.log(resultData, "result data--->");
    data = resultData;

    return customResponse(res, true, 200, data, "success");
  } catch (err) {
    return failureResponse(res, err);
  }
};

//------ user related to projects ------//
const projectUserDetails = async (req, res) => {
  let data;
  try {
    const {
      search_text = "",
      project_id = "",
      page_no = 1,
      limit = 10,
      assign_by = "",
      user_id = "",
    } = req.query;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        first_name: true,
        last_name: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            role_id: true,
            organisation_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }
    let whereCondition = {
      deleted_at: null,
      project_id: Number(project_id),
      assign_to: {
        not: existUser.id,
      },
    };

    if (search_text) {
      whereCondition = {
        ...whereCondition,
        // OR: [
        // {
        assignTo: {
          email: {
            contains: search_text, // Search email in assignTo (user assigned to the project)
            mode: "insensitive", // Optional: makes the search case-insensitive
          },
        },
        // },
        // {
        //   assignBY: {
        //     email: {
        //       contains: search_text, // Search email in assignBY (user who assigned the project)
        //       mode: "insensitive", // Optional: makes the search case-insensitive
        //     },
        //   },
        // },
        // ],
      };
    }

    const skip = (pageInt - 1) * limitInt;
    if (assign_by) {
      whereCondition.assign_by = Number(assign_by); // Assuming assign_by is a numeric field in the database
    }

    const usersProject = await prismaSubMasterDb.ProjectUser.findMany({
      where: whereCondition,
      skip: skip, // Apply pagination skip
      take: limitInt, // Apply pagination limit
      select: {
        id: true,
        assign_by: true,
        assign_to: true,
        project_id: true,
        assignTo: {
          select: {
            id: true,
            first_name: true,
            last_name: true,
            create_by: true,
            email: true,
            created_at: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                role_id: true,
                organisation_id: true,
              },
            },
          },
        },
        assignBY: {
          select: {
            id: true,
            first_name: true,
            last_name: true,
            create_by: true,
            email: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                role_id: true,
                organisation_id: true,
              },
            },
          },
        },
      },
    });

    // console.log(usersProject, "user projectssss ---->");

    const usersWithRoles = await Promise.all(
      usersProject.map(async (userProject) => {
        // Assuming assignTo contains a role_id and you want to fetch a single role based on that.
        const role = await prismaMasterDb.roles.findFirst({
          where: {
            id: userProject?.assignTo?.UserInfo?.role_id,
            deleted_at: null,
            // Match the role_id from the assignTo field
          },
        });

        // Return the user project along with their role
        return {
          ...userProject,
          role: role, // Attach the single role to the user project
        };
      })
    );

    const totalCount = await prismaSubMasterDb.ProjectUser.count({
      where: whereCondition,
    });
    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    data = {
      users: usersWithRoles,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    return responseHandler.success(
      res,
      data,
      "Member fetched successfully.",
      200
    );
  } catch (err) {
    console.log(err, "check therer ererer");
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

//------ link related to projects ------//
const projectLinksDetails = async (req, res) => {
  let data;
  try {
    const {
      search_text = "",
      project_id = "",
      manager_id = "",
      member_id = "",
      page_no = 1,
      limit = 10,
    } = req.query;

    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    const skip = (pageInt - 1) * limitInt;

    let whereCondition = {
      deleted_at: null,
      project_id: Number(project_id),
    };

    if (search_text) {
      whereCondition = {
        ...whereCondition,
        OR: [
          {
            ManagedBy: {
              email: {
                contains: search_text,
                mode: "insensitive",
              },
            },
          },
          {
            created_by: {
              email: {
                contains: search_text,
                mode: "insensitive",
              },
            },
          },
        ],
      };
    }

    if (manager_id) {
      whereCondition.managed_by = Number(manager_id);
    }

    if (member_id) {
      whereCondition.uploaded_by_id = Number(member_id);
    }
    const allLinks = await prismaSubMasterDb.Backlink.findMany({
      where: whereCondition,
      skip: skip, // Apply pagination skip
      take: limitInt, // Apply pagination limit
      include: {
        ManagedBy: true,
        created_by: true,
      },
    });

    const totalCount = await prismaSubMasterDb.Backlink.count({
      where: whereCondition,
    });

    const allMangerAndMember = await prismaSubMasterDb.Backlink.findMany({
      where: {
        deleted_at: null,
        project_id: Number(project_id),
      },
      include: {
        ManagedBy: true,
        created_by: true,
      },
    });

    const seenManagedByIds = new Set();

    // Use map to create the list of ManagedBy users, ensuring uniqueness
    const managedByUsers = allMangerAndMember
      .map((item) => {
        // Get the ManagedBy's ID
        const managedById = item.ManagedBy.id;

        // Check if this ID has been processed already
        if (!seenManagedByIds.has(managedById)) {
          seenManagedByIds.add(managedById); // Mark this ID as seen
          return item.ManagedBy; // Include this ManagedBy object
        }

        // Return null for duplicates (this will be filtered out later)
        return null;
      })
      .filter(Boolean);

    // Initialize an empty set to track seen created_by IDs
    const seenCreatedByIds = new Set();

    // Use map to create the list of created_by users, ensuring uniqueness
    const createdByUsers = allMangerAndMember
      .map((item) => {
        // Get the created_by's ID
        const createdById = item.created_by.id;

        // Check if this ID has been processed already
        if (!seenCreatedByIds.has(createdById)) {
          seenCreatedByIds.add(createdById); // Mark this ID as seen
          return item.created_by; // Include this created_by object
        }

        // Return null for duplicates (this will be filtered out later)
        return null;
      })
      .filter(Boolean);
    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    data = {
      links: allLinks,
      backLinkManager: managedByUsers,
      backLinkCreator: createdByUsers,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    // console.log(data, "dastdtastdfsautd");
    return responseHandler.success(
      res,
      data,
      "Project links successfully.",
      200
    );
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, errorCodes.NOT_FOUND, err.message, 500);
  }
};

// single project details //
const fetchSingleProject = async (req, res) => {
  try {
    console.log("enter in api--->");
    let data;
    const userData = req.user;
    const { id } = req.params;
    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          id: true,
          user_id: true,
          organisation_id: true,
          role_id: true,
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const project_details = await prismaSubMasterDb.Project.findUnique({
      where: {
        id: Number(id),
        deleted_at: null,
      },
      select: {
        id: true,
        domain_name: true,
        domain_url: true,
        time_around: true,
        time_around_days: true,
        category: {
          select: {
            id: true,
            category_name: true,
          },
        },
        ProjectPackage: {
          select: {
            id: true,
            title: true,
          },
        },
      },
    });

    data = project_details;
    return responseHandler.success(
      res,
      data,
      "Project details fetch successfully.",
      200
    );
  } catch (err) {
    console.log(err, "err-->");
    return responseHandler.error(
      res,
      errorCodes.BAD_REQUEST,
      errorCodes.BAD_REQUEST.message,
      500
    );
  }
};

// edit project //

const editProject = async (req, res) => {
  try {
    let data;
    const userData = req.user;

    const {
      id,
      domain_name,
      domain_url,
      category_id,
      time_around,
      seo_packages,
    } = req.body;
    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        role_id: true,
        email: true,
      },
    });

    if (!existUser) {
      return responseHandler.error(
        res,
        errorCodes.USER_NOT_EXIST,
        errorCodes.USER_NOT_EXIST,
        400
      );
    }

    const existingProject = await prismaSubMasterDb.Project.findUnique({
      where: {
        id: id,
        deleted_at: null,
      },
    });

    if (!existingProject) {
      return responseHandler.error(
        res,
        errorCodes.PROJECT_NOT_EXIST,
        errorCodes.PROJECT_NOT_EXIST,
        400
      );
    }

    // Create an object with only the fields to update
    const updateData = {};

    if (domain_name) {
      updateData.domain_name = domain_name;
    }

    if (domain_url) {
      updateData.domain_url = domain_url;
    }

    if (category_id) {
      updateData.category_id = category_id;
    }

    if (seo_packages) {
      updateData.package_id = Number(seo_packages);
    }

    if (time_around) {
      let getProjectTime = projectTimefn(
        Number(time_around),
        existingProject.created_at
      );
      updateData.time_around_days = Number(time_around);
      updateData.time_around = getProjectTime;
    }
    // Now update the project with only the provided fields
    const updatedProject = await prismaSubMasterDb.Project.update({
      where: {
        id: id,
      },
      data: updateData,
    });

    data = updatedProject;
    return responseHandler.success(
      res,
      data,
      "Project details fetch successfully.",
      200
    );
  } catch (err) {
    console.log(err, "erer");
    return responseHandler.error(
      res,
      errorCodes.BAD_REQUEST,
      errorCodes.BAD_REQUEST.message,
      500
    );
  }
};

// delete project //

const deleteProject = async (req, res) => {
  try {
    let data;
    const userData = req.user;
    const ROLE = Object.keys(userData)[0];

    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE]?.id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            role_id: true,
            user_id: true,
            organisation_id: true,
          },
        },
      },
    });

    if (!existUser)
      return customResponse(res, false, 400, {}, "User not found.");

    console.log("existUser", existUser);

    const { id } = req.body;

    const existingProject = await prismaSubMasterDb.Project.findUnique({
      where: {
        id: id,
        deleted_at: null,
      },
    });

    if (!existingProject) {
      return responseHandler.error(
        res,
        errorCodes.PROJECT_NOT_EXIST,
        errorCodes.PROJECT_NOT_EXIST,
        400
      );
    }

    await prismaSubMasterDb.Project.update({
      where: {
        id: id,
        deleted_at: null,
      },
      data: {
        deleted_at: new Date(), // Set the `deletedAt` field to the current date/time
      },
    });

    return responseHandler.success(
      res,
      {},
      "Project delete successfully.",
      200
    );
  } catch (err) {
    console.log(err, "erororororo");
    // return responseHandler.error(
    //   res,
    //   errorCodes.BAD_REQUEST,
    //   errorCodes.BAD_REQUEST.message,
    //   500
    // );
  }
};

const reportsCounter = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const { org_id, page_no, rows } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(rows, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    const skip = (pageInt - 1) * limitInt;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    console.log(ROLE, "checking role--->");
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    // find team //

    const findTeam = await prismaSubMasterDb.User.findFirst({
      where: {
        deleted_at: null,
        id: Number(org_id),
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            role_id: true,
            organisation_id: true,
            user_id: true,
          },
        },
      },
    });

    if (!findTeam) {
      return responseHandler.error(
        res,
        errorCodes.USER_NOT_EXIST,
        errorCodes.USER_NOT_EXIST,
        400
      );
    }

    const projectDetails = await prismaSubMasterDb.Project.findMany({
      where: {
        deleted_at: null,
        created_by_id: Number(org_id),
      },
      skip: skip,
      take: limitInt,
    });

    // total project count //
    const projectCount = await prismaSubMasterDb.Project.count({
      where: {
        deleted_at: null,
        created_by_id: Number(org_id),
      },
    });

    const totalProjectPages = Math.ceil(projectCount / limitInt);

    // total project count of user //

    const projctofUser = await prismaSubMasterDb.Project.count({
      where: {
        deleted_at: null,
        created_by_id: Number(org_id),
      },
      // select: {
      //   id: true,
      //   ProjectMember: {
      //     id: true,
      //     assign,
      //   },
      // },
    });

    const teamCount = await prismaSubMasterDb.ProjectUser.findMany({
      where: {
        deleted_at: null,
        assign_by: Number(org_id),
      },
      include: {
        assignTo: true,
      },
    });

    let Managers = 0;
    let Leads = 0;
    let Members = 0;

    // teamCount.forEach((item) => {
    //   // Ensure the related assignTo exists and has a role_id
    //   if (item.assignTo && item.assignTo.role_id) {
    //     switch (item.assignTo.role_id) {
    //       case 3:
    //         Managers++;
    //         break;
    //       case 4:
    //         Leads++;
    //         break;
    //       case 5:
    //         Members++;
    //         break;
    //       default:
    //         break;
    //     }
    //   }
    // });

    data = {
      totalMangers: Managers,
      totalLeads: Leads,
      totalMembers: Members,
      projectDetails: projectDetails,
      totalProjectCount: projectCount,
      totalProjectPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };
    return responseHandler.success(
      res,
      data,
      "Organisation details fetch successfully.",
      200
    );
    // console.log(projectCount, "manger count", mangerCount);
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, errorCodes.BAD_REQUEST, err.message, 500);
  }
};

// feth refer domai category //

const allReferDomainCategory = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const allCategory = await prismaSubMasterDb.referDomainCategory.findMany({
      where: {
        deleted_at: null,
      },
      select: {
        id: true,
        category_name: true,
      },
    });

    data = {
      categories: allCategory,
    };

    return responseHandler.success(
      res,
      data,
      "Organisation details fetch successfully.",
      200
    );
  } catch (err) {
    return failureResponse(res, err);
  }
};

const allReferDomain = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { page_no = 1, limit = 10, search_text = "" } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    const searchFilter = search_text
      ? {
          OR: [
            { rd_link: { contains: search_text, mode: "insensitive" } },
            {
              RdCategory: {
                category_name: { contains: search_text, mode: "insensitive" },
              },
            },
          ],
        }
      : {};

    const whereClause = {
      deleted_at: null,

      ...searchFilter,
    };

    if (existUser?.UserInfo?.role_id === 5) {
      whereClause.user_id = existUser?.id;
    }

    let allReferingDomain = [];
    if (existUser?.UserInfo?.role_id !== 1) {
      allReferingDomain = await prismaSubMasterDb.ReferDomain.findMany({
        where: whereClause,
        select: {
          id: true,
          category_id: true,
          rd_link: true,
          user_id: true,
          created_at: true,
          status: true,
          UserRd: {
            select: {
              id: true,
              email: true,
            },
          },

          RdCategory: {
            select: {
              id: true,
              category_name: true,
            },
          },
        },
        skip: skip,
        take: limitInt,
      });
    } else {
      allReferingDomain = await prismaSubMasterDb.ReferDomain.findMany({
        where: whereClause,
        select: {
          id: true,
          category_id: true,
          rd_link: true,
          user_id: true,
          created_at: true,
          status: true,
          UserRd: {
            select: {
              id: true,
              email: true,
            },
          },

          RdCategory: {
            select: {
              id: true,
              category_name: true,
            },
          },
        },
        skip: skip,
        take: limitInt,
      });
    }

    let totalCount = await prismaSubMasterDb.ReferDomain.count({
      where: {
        deleted_at: null,
      },
    });

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // Prepare the response data
    data = {
      allReferingDomain,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    return customResponse(res, true, 200, data, "Success");
  } catch (err) {
    return failureResponse(res, err);
  }
};

// fetch guide lines //

const fethAllGuidelines = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const { page_no, rows, domain_id = "" } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(rows, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    const skip = (pageInt - 1) * limitInt;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    // filters

    let filters = {
      deleted_at: null,
    };

    let allGuideLines;

    if (domain_id !== "") {
      const fetchGuideLines =
        await prismaSubMasterDb.ProjectGuideLines.findMany({
          where: {
            project_id: Number(domain_id),
            deleted_at: null,
          },
          include: {
            GuideLineId: true,
          },
        });

      allGuideLines =
        fetchGuideLines.length > 0
          ? fetchGuideLines?.map((guide) => {
              return guide.GuideLineId;
            })
          : [];
    } else {
      allGuideLines = await prismaSubMasterDb.guideLines.findMany({
        where: {
          deleted_at: null,
        },
      });
    }

    data = allGuideLines;

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, errorCodes.BAD_REQUEST, err.message, 500);
  }
};

const projectGuideLines = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const { page_no, rows, domain_id = "" } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(rows, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    const skip = (pageInt - 1) * limitInt;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    // filters

    let filters = {
      deleted_at: null,
    };

    const fetchProjectGuide =
      await prismaSubMasterDb.ProjectGuideLines.findFirst({
        where: {
          project_id: Number(domain_id),
          deleted_at: null,
        },
        select: {
          id: true,
          guide_id: true,
          project_id: true,
          GuideLineId: {
            select: {
              id: true,
              title: true,
              package_features: true,
            },
          },
        },
      });

    const cleanedFeatures =
      fetchProjectGuide?.GuideLineId?.package_features.map((feature) => {
        return Object.fromEntries(
          Object.entries(feature).filter(
            ([key, value]) =>
              typeof value === "number" &&
              ![
                "id",
                "status",
                "package_id",
                "deleted_at",
                "created_at",
                "updated_at",
              ].includes(key)
          )
        );
      });

    // fetch guids //
    const allGuideLines = await prismaSubMasterDb.guideLines.findMany({
      where: {
        deleted_at: null,
      },
      select: {
        id: true,
        task_name: true,
      },
    });

    const matchedGuideLines = [];

    if (cleanedFeatures?.length && allGuideLines?.length) {
      for (const guide of allGuideLines) {
        const task = guide.task_name;

        for (const feature of cleanedFeatures) {
          if (feature.hasOwnProperty(task)) {
            matchedGuideLines.push({
              guide_line_id: guide.id,
              task_name: task,
              value: feature[task],
            });
          }
        }
      }
    }

    console.log(matchedGuideLines, "MATHED guide lines");
    // const transformed = Object.entries(cleanedFeatures[0]).map(([key, value]) => ({
    //   key,
    //   value
    // }));

    data = matchedGuideLines;

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err);
    return responseHandler.error(res, errorCodes.BAD_REQUEST, err.message, 500);
  }
};

const getSeoPackages = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const { page_no = 1, rows = 10 } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(rows, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    const skip = (pageInt - 1) * limitInt;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    // filters

    const fetchPakcages = await prismaSubMasterDb.seo_packages.findMany({
      where: {
        deleted_at: null,
      },
    });

    data = fetchPakcages;

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err);
    return failureResponse(res, err);
  }
};

const fetchprojectPackages = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const { package_id } = req.query;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const fetchPackages = await prismaSubMasterDb.package_features.findFirst({
      where: {
        deleted_at: null,
        package_id: Number(package_id),
      },
    });

    if (!fetchPackages) {
      return customResponse(res, false, 400, {}, "Package not found.");
    }

    //
    const modifiedResult = _.omit(fetchPackages, [
      "id",
      "package_id",
      "created_at",
      "updated_at",
      "status",
      "deleted_at",
    ]);

    console.log(modifiedResult, "modifiedResult");


    const resultArray = Object.entries(modifiedResult).map(([key, value]) => (
      {
      real_key : key,  
      key: convertKey(key),
      value: value,
    }));

    data = resultArray;

    console.log(data, "data");

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

const fetchAllLanguagse = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const allLanguages = await mongoClient?.language.findMany({
      select: {
        id: true,
        language_name: true,
        language_code: true,
        created_date: true,
      },
    });

    data = allLanguages;

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

const fetchAllRegions = async (req, res) => {
  try {
    let data = {};
    // const userData = req.user;

    // const ROLE = Object.getOwnPropertyNames(userData)[0];

    // // EXIST AUTH USER //
    // const existUser = await prismaSubMasterDb.User.findFirst({
    //   where: {
    //     id: userData[ROLE].id,
    //     deleted_at: null,
    //   },
    //   select: {
    //     id: true,
    //     email: true,
    //     UserInfo: {
    //       select: {
    //         id: true,
    //         user_id: true,
    //         organisation_id: true,
    //         role_id: true,
    //       },
    //     },
    //   },
    // });

    // if (!existUser) {
    //   return customResponse(res, false, 400, {}, "User not found.");
    // }

    const allRegions = await mongoClient?.region.findMany({
      select: {
        id: true,
        region_name: true,
        region_code: true,
        region_country: true,
        searchvolume_country_id: true,
      },
    });
    data = allRegions;
    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

const fetchAllKeywordsByProjectId = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;
    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // Fetch authenticated user from SQL
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE]?.id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { project_id } = req.params;

    if (!project_id) {
      return customResponse(res, false, 400, {}, "Project ID is required.");
    }

    // Check if project exists in SQL
    const projectExistsInSql = await prismaSubMasterDb.Project.findFirst({
      where: {
        id: Number(project_id),
        created_by_id: existUser.id,
      },
    });

    if (!projectExistsInSql) {
      return customResponse(res, false, 400, {}, "Project not found ");
    }

    // Check if project exists in MongoDB
    const projectExistsInMongo = await mongoClient.group.findFirst({
      where: {
        fk_user_id: existUser.id,
        domain_name: projectExistsInSql?.domain_url,
      },
    });

    // if (!projectExistsInMongo) {
    //   return customResponse(res, false, 400, {}, "Project not found in MongoDB.");
    // }

    // Fetch associated keywords from MongoDB
    const projectKeywords = await mongoClient.keyword.findMany({
      where: {
        fk_group_id: projectExistsInMongo?.id_,
      },
    });

    data = projectKeywords;

    return responseHandler.success(res, data, "Success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

// const getProjectById = async (req, res) => {
//   try {
//     let data = {};
//     const userData = req.user;
//     const ROLE = Object.getOwnPropertyNames(userData)[0];

//     // Fetch authenticated user from SQL
//     const existUser = await prismaSubMasterDb.User.findFirst({
//       where: {
//         id: userData[ROLE]?.id,
//         deleted_at: null,
//       },
//       select: {
//         id: true,
//         email: true,
//         UserInfo: {
//           select: {
//             id: true,
//             user_id: true,
//             organisation_id: true,
//             role_id: true,
//           },
//         },
//       },
//     });

//     if (!existUser) {
//       return customResponse(res, false, 400, {}, "User not found.");
//     }

//     const { project_id } = req.params;

//     if (!project_id) {
//       return customResponse(res, false, 400, {}, "Project ID is required.");
//     }

//     // Check if project exists in SQL
//     const projectExistsInSql = await prismaSubMasterDb.Project.findFirst({
//       where: {
//         id: Number(project_id),
//         created_by_id: existUser.id,
//       },
//     });

//     if (!projectExistsInSql) {
//       return customResponse(res, false, 400, {}, "Project not found ");
//     }

//     // // Check if project exists in MongoDB
//     // const projectExistsInMongo = await mongoClient.group.findFirst({
//     //   where: {
//     //     fk_user_id: existUser.id,
//     //     domain_name: projectExistsInSql?.domain_url,
//     //   },
//     // });

//     // if (!projectExistsInMongo) {
//     //   return customResponse(res, false, 400, {}, "Project not found in MongoDB.");
//     // }

//     data = projectExistsInSql;

//     return responseHandler.success(res, data, "Success", 200);
//   } catch (err) {
//     return failureResponse(res, err);
//   }
// };

const getProjectById = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;
    const ROLE = Object.getOwnPropertyNames(userData)[0];

    // Fetch authenticated user
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE]?.id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { project_id } = req.params;

    if (!project_id) {
      return customResponse(res, false, 400, {}, "Project ID is required.");
    }

    // Fetch project with its associated guideline entry
    const projectInSQL = await prismaSubMasterDb.Project.findFirst({
      where: {
        id: Number(project_id),
        created_by_id: existUser.id,
      },
      include: {
        ProjectGuideLines: {
          select: {
            guide_id: true,
            link_count: true,
            status: true,
          },
        },
      },
    });

    const projectInMongo = await mongoClient.group.findFirst({
      where: {
        fk_user_id: existUser.id,
        domain_name: projectInSQL?.domain_url,
      },
    });

    if (!projectInSQL || !projectInMongo) {
      return customResponse(res, false, 400, {}, "Project not found");
    }

    // Build response object
    data = {
      ...projectInSQL,
      mongo_group_id: projectInMongo?.id_,
      mongo_group_url: projectInMongo?.domain_name,
      mongo_group_user_id: projectInMongo?.fk_user_id,
      guide_lines: projectInSQL?.ProjectGuideLines.map((g) => ({
        guide_id: g.guide_id,
        link_count: g.link_count,
        status: g.status,
      })),
    };

    // console.log("data", data);

    return responseHandler.success(res, data, "Success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

const gettAllGuidelines = async (req, res) => {
  try {
    const data = await prismaSubMasterDb.guideLines.findMany();
    // console.log("data", data);
    return responseHandler.success(res, data, "Success", 200);
  } catch (err) {
    return failureResponse(res, err);
  }
};

export {
  createDomain,
  fetchAllDomain,
  fetchDomainCategory,
  assignProject,
  projectDetails,
  projectLinksDetails,
  projectUserDetails,
  fetchSingleProject,
  editProject,
  deleteProject,
  reportsCounter,
  allReferDomainCategory,
  fethAllGuidelines,
  projectGuideLines,
  getSeoPackages,
  fetchprojectPackages,
  projectGuideLineDetails,
  fetchProjectsPackages,
  fetchAllMongoProjects,
  fetchAllCompititors,
  fetchAllKewords,
  allReferDomain,
  fetchAllLanguagse,
  fetchAllRegions,
  fetchAllKeywordsByProjectId,
  getProjectById,
  addKeywords,
  deleteKeyword,
  gettAllGuidelines,
};
