import { Router } from "express";
import { addBackLinks, addLinksManually, getAllLinks, getReportsinks, linkChecker, linkJobs } from "./backLinkController.js";
import { handleCSVUpload } from "../../middlewares/multer.js";
import { authenticateUser } from "../../middlewares/authMiddleware.js";

const backlinkRouter = Router()

backlinkRouter.post('/add-backlinks',authenticateUser,handleCSVUpload,addBackLinks) 

backlinkRouter.get("/get-alllinks",authenticateUser,getAllLinks)

backlinkRouter.get("/get-report-link",authenticateUser,getReportsinks)
backlinkRouter.post("/add-links-manual",authenticateUser,addLinksManually)

backlinkRouter.post("/check-links",linkChecker)



backlinkRouter.get("/get-jobs",authenticateUser,linkJobs)
export default backlinkRouter