import mongoose from "mongoose";

const AddBackLinkSchema = new mongoose.Schema(
  {
    domain: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Domain",
      required: true,
    },
    type: {
      type: String,
      required: true,
    },
    linkFrom: {
      type: String,
      required: true,
    },
    achorText: {
      type: String,
      required: true,
    },
    targetLink: {
      type: String,
      required: true,
    },
    linkPartner: {
      type: String,
      required: true,
    },
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "User",
    },
    isManualy: {
      type: Boolean,

      default: false,
    },
    byFile: {
      type: Boolean,
      default: false,
    },
    link: {
      type: String,
      require: true,
      default: null,
    },
    deletedAt: { type: Date, default: null },
  },
  { timestamps: true }
);

const CreateBackLink = mongoose.model("BackLink", AddBackLinkSchema);

export default {
  CreateBackLink,
};
