import responseHandler from "../../utils/responseHandler.js";
import { parseCSV, parseExcel } from "../../utils/fileParser.js";
import * as cheerio from "cheerio";

import axios from "axios";

import { PrismaClient as PrismaClient1 } from "../../../prisma/generated/client1/index.js";
import { PrismaClient as PrismaClient2 } from "../../../prisma/generated/client2/index.js";
import errorCodes from "../../utils/errorCodes.js";
// import { processingQueue } from "../../queues/index.js";
import {
  extractDomain,
  generateUniqueFourDigitNumber,
} from "../../utils/helper.js";
import { customResponse } from "../../utils/responseFn.js";
// import { processingQueue } from "../../queues/index.js";

// Use the clients...

const prismaMasterDb = new PrismaClient1();

const prismaSubMasterDb = new PrismaClient2();

// get the status code of the url //
// const checkUrlStatus = async (url, domain) => {
//   try {
//     // Fetch the URL
//     const response = await axios.get(url);

//     const statusCode = response?.status;

//     const domainDetails = await prismaSubMasterDb.Project.findUnique({
//       where: {
//         id: Number(domain),
//         deleted_at: null,
//       },
//     });

//     // Load the HTML response into Cheerio to extract anchor tags
//     const isIndexedInGoogle = await checkIndexedInGoogle(url);

//     const $ = cheerio.load(response.data);

//     let datePublished = null;
//     let dateModified = null;
//     let addedDate = null;
//     // Check if the page contains a publish date (common meta tags or time tags)
//     const metaDate =
//       $('meta[property="article:published_time"]').attr("content") ||
//       $('meta[name="date"]').attr("content") ||
//       $("time").attr("datetime");

//     if (metaDate) {
//       datePublished = new Date(metaDate);
//       addedDate = new Date(metaDate);
//     } else {
//       const scriptTags = $("script[type='application/ld+json']");

//       scriptTags.each((index, element) => {
//         const jsonData = $(element).html();

//         try {
//           const parsedData = JSON.parse(jsonData);

//           const dateDetails =
//             parsedData["@graph"] &&
//             parsedData["@graph"]
//               .filter((item) => item.datePublished && item.dateModified) // Filter objects with datePublished and dateModified
//               .map((item) => ({
//                 datePublished: item.datePublished,
//                 dateModified: item.dateModified,
//               }));

//           if (dateDetails) {
//             datePublished = new Date(dateDetails[0]?.datePublished);
//             addedDate = new Date(dateDetails[0]?.datePublished);

//             dateModified = new Date(dateDetails[0]?.dateModified);
//           }

//           // Check if the JSON contains 'datePublished' or 'dateModified'
//         } catch (error) {
//           console.error("Error parsing JSON-LD data: ", error);
//         }
//       });
//     }

//     // // Extract all anchor tags
//     const anchorTags = $("a");
//     let targetedUrl = null;
//     let achorText = null;
//     let rel = null;
//     // // Check if any anchor tag href matches the current URL
//     anchorTags.each((index, element) => {
//       const href = $(element).attr("href");
//       const text = $(element).text();
//       const relationLink = $(element).attr("rel");
//       // console.log(domain_url,"domain urlllll",href)
//       const regex = new RegExp(domainDetails.domain_url, "i");

//       if (regex.test(href)) {
//         targetedUrl = href;
//         achorText = text;
//         rel = relationLink;
//       }
//     });

//     // // Check if the URL is indexed by Google (simulated by a search query)
//     return {
//       link: url,
//       status_code: statusCode,
//       targeted_url: targetedUrl ? targetedUrl : null, // If no targeted URL is found, use the original URL
//       is_index: isIndexedInGoogle?.length > 0 ? true : false,
//       anchor_text: achorText ? achorText : null,
//       relation: rel === undefined ? "Do-follow" : rel,
//       first_seen: datePublished,
//       last_seen: dateModified,
//       added_date: addedDate,
//     };
//   } catch (error) {
//     console.log(error, "erroer");
//     // console.log(`Error fetching URL ${url}:${error}`);
//     return {
//       link: url,
//       status_code: error.status,
//       targeted_url: null,
//       is_index: false,
//       anchor_text: null,
//       relation: null,
//       first_seen: null,
//       last_seen: null,
//       added_date: null,
//     };
//   }
// };

// // Simulate checking if a URL is indexed in Google

// // check url status promise //

// const checkAllUrlsStatus = async (urls, domain) => {
//   const results = await Promise.all(
//     urls.map((url) => checkUrlStatus(url, domain))
//   );

//   const modifyData = JSON.stringify(results, null, 2);

//   return modifyData;
// };

// checking domain duplicate //

// Extract domain from the URL
// function extractDomain(url) {
//   try {
//     const parsedUrl = new URL(url);
//     return parsedUrl.origin;
//   } catch (error) {
//     console.error("Invalid URL:", error);
//     return null;
//   }
// }

// add back links controller function//

const chunkArray = (array, size) => {
  const result = [];
  for (let i = 0; i < array.length; i += size) {
    result.push(array.slice(i, i + size));
  }
  return result;
};

const addBackLinks = async (req, res) => {
  try {
    let data = null;

    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        first_name: true,
        last_name: true,
        UserInfo: {
          id: true,
          user_id: true,
          organisation_id: true,
          role_id: true,
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const { domain_id } = req.body;

    const { path, extention, originalname } = req.file;

    let parsedLink;
    if (extention === ".xls" || extention === ".xlsx") {
      parsedLink = await parseExcel(path);
    } else {
      parsedLink = await parseCSV(path);
    }

    const createJob = await prismaSubMasterDb.userJobs.create({
      data: {
        user_id: existUser.id,
        name: `file:${generateUniqueFourDigitNumber()}-${originalname}`,
        type: 1,
        total_links: parsedLink?.length > 0 ? parsedLink?.length : 0,
        project_id: Number(domain_id),
        processing_status: 0,
      },
    });

    if (!createJob) {
      return customResponse(res, false, 400, {}, "Job not found");
    }
    const modifyData = parsedLink.map((item, index) => {
      return {
        link_url: item,
        project_id: Number(domain_id),
        userId: existUser.id,
        job_id: createJob.id,
        status: "ONGOING",
      };
    });

    const storeLinks = await prismaSubMasterDb.tempLinks.createMany({
      data: modifyData,
    });

    if (!storeLinks) {
      return responseHandler.error(
        res,
        errorCodes.USER_NOT_EXIST,
        "Error while storing links.",
        400
      );
    }
    // const linkChunks = chunkArray(parsedLink, 10);

    // linkChunks.forEach((chunk) => {
    //   let linkObj = {
    //     links: chunk,
    //     project_id: domain_id,
    //     uploaded_by_id: existUser.id,
    //     job_id: createJob.id,
    //   };
    //   processingQueue.add(linkObj);
    // });
    return res.status(202).send("data uploading...");
  } catch (err) {
    console.log(err, "err in code");
    return responseHandler.error(res, err, "error", 500);
  }
};

// upload links manually controller function //
const addLinksManually = async (req, res) => {
  try {
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        last_name: true,
        first_name: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found");
    }

    const { links, domain_id, link_category_id } = req.body;

    if (!link_category_id) {
      return customResponse(res, false, 400, {}, "Link category requiered.");
    }

    const createJob = await prismaSubMasterDb.userJobs.create({
      data: {
        user_id: existUser.id,
        name: `file:${generateUniqueFourDigitNumber()}`,
        type: 0,
        total_links: links?.length > 0 ? links?.length : 0,
        project_id: Number(domain_id),
        processing_status: 0,
      },
    });

    if (!createJob) {
      return customResponse(res, false, 400, {}, "Link jobs not found");
    }

    const modifyData = links.map((item, index) => {
      return {
        link_url: item,
        project_id: Number(domain_id),
        userId: existUser.id,
        job_id: createJob.id,
        status: "ONGOING",
        links_category_id: Number(link_category_id),
      };
    });

    const storeLinks = await prismaSubMasterDb.tempLinks.createMany({
      data: modifyData,
    });

    if (!storeLinks) {
      return responseHandler.error(
        res,
        errorCodes.UPLOAD_LINKS,
        "Error while storing links.",
        400
      );
    }

    return res.status(202).send("data  uploading...");
  } catch (err) {
    console.log(err, "ereroer inde d");
    return responseHandler.error(res, err, "err", 500);
  }
};

// get all links controller function //
const getAllLinks = async (req, res) => {
  try {
    let data;

    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const {
      page_no = 1,
      limit = 10,
      domain_id = "",
      achorText = "",
      status = "",
      index = "",
      duplicate = "",
    } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    // Building the filter object for query
    const filters = {};

    if (status !== "") {
      filters.link_status = Number(status);
    }

    if (achorText !== "") {
      filters.achorText = { contains: achorText }; // Adjust this as needed based on your exact column name
    }

    if (existUser.UserInfo?.role_id === 5) {
      filters.uploaded_by_id = existUser?.id;
    }

    // if (duplicate !== "") {
    //   filters.duplicate = duplicate === "true"; // Assuming 'duplicate' comes as a string "true" or "false"
    // }

    if (index !== "") {
      filters.is_index = index.trim().toLowerCase() === "true"; // Assuming `index` should be applied as an exact match
    }

    let backlinks;
    let totalCount;
    if (existUser.UserInfo?.role_id == 1) {
      if (domain_id !== "") {
        backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            deleted_at: null,
            project_id: Number(domain_id),
            ...filters,
          },
          skip: skip,
          take: limitInt,
          include: {
            project: true, // Include the related project details in the result
          },
          orderBy: {
            created_at: "desc", // Replace 'created_at' with the field you want to order by
          },
          // Limit the number of results per page
        });

        // Get total count for pagination info
        totalCount = await prismaSubMasterDb.backlink.count({
          where: {
            deleted_at: null,
            ...filters,
          },
        });
      }
    }
    // else if (existUser.UserInfo?.role_id == 2) {
    //   if (domain_id !== "") {
    //     backlinks = await prismaSubMasterDb.backlink.findMany({
    //       where: {
    //         deleted_at: null,
    //         project_id: Number(domain_id),
    //         ...filters,
    //       },
    //       orderBy: {
    //         created_at: "desc", // Replace 'created_at' with the field you want to order by
    //       },
    //       skip: skip,
    //       take: limitInt,
    //       include: {
    //         project: true, // Include the related project details in the result
    //       },
    //       // Limit the number of results per page
    //     });

    //     // Get total count for pagination info
    //     totalCount = await prismaSubMasterDb.backlink.count({
    //       where: {
    //         deleted_at: null,
    //         ...filters,
    //       },
    //     });
    //   }
    // }
    else if (existUser.UserInfo?.role_id == 5) {
      if (domain_id !== "") {
        backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            deleted_at: null,
            project_id: Number(domain_id),
            ...filters,
          },
          orderBy: {
            created_at: "desc", // Replace 'created_at' with the field you want to order by
          },
          skip: skip,
          take: limitInt,
          include: {
            project: true, // Include the related project details in the result
          },
          // Limit the number of results per page
        });

        // Get total count for pagination info
        totalCount = await prismaSubMasterDb.backlink.count({
          where: {
            deleted_at: null,
            ...filters,
          },
        });
      }
    } else {
      if (domain_id !== "") {
        backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            deleted_at: null,
            project_id: Number(domain_id),
            ...filters,
          },
          orderBy: {
            created_at: "desc", // Replace 'created_at' with the field you want to order by
          },
          skip: skip,
          take: limitInt,
          include: {
            project: true, // Include the related project details in the result
          },
          // Limit the number of results per page
        });

        // Get total count for pagination info
        totalCount = await prismaSubMasterDb.backlink.count({
          where: {
            deleted_at: null,
            ...filters,
          },
        });
      }
    }

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // Prepare the response data
    data = {
      backlinks,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err, "err in code");
    return responseHandler.error(res, err, "error", 500);
  }
};

// report links //

const getReportsinks = async (req, res) => {
  try {
    let data;
    let backlinks;
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findFirst({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
      select: {
        id: true,
        email: true,
        UserInfo: {
          select: {
            id: true,
            user_id: true,
            organisation_id: true,
            role_id: true,
          },
        },
      },
    });

    if (!existUser) {
      return customResponse(res, false, 400, {}, "User not found.");
    }

    const {
      page_no = 1,
      limit = 10,
      team_id = "",
      domain_id = "",
      achorText = "",
      status = "",
      index = "",
      duplicate = "",
    } = req.query; // Defaults: page 1, limit 10

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(limit, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    // Building the filter object for query
    const filters = {
      deleted_at: null,
    };
    // if (domain_id !== "") {
    //   filters.domain_id = domain_id;
    // }

    let totalCount;

    let existTeam;
    let userReports;
    if (existUser?.UserInfo?.role_id == 1) {
      if (domain_id !== "") {
        console.log(domain_id, "domain id ----->");

        existTeam = await prismaSubMasterDb.User.findFirst({
          where: {
            deleted_at: null,
            id: Number(team_id),
            memberProjects: {
              some: {
                // ← use `some` to filter “users who have at least one memberProject matching this”
                project_id: parseInt(domain_id),
              },
            },
          },
          select: {
            id: true,
            email: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                organisation_id: true,
                role_id: true,
              },
            },
            memberProjects: {
              select: {
                id: true,
                project_id: true,
                assign_to: true,
                assignBY: {
                  select: {
                    id: true,
                    email: true,
                  },
                },
              },
            },
            // created_projects: {
            //   select: {
            //     id: true,
            //     domain_name: true,
            //     domain_url: true,
            //     organisation_id:true
            //   },
            // },
          },
        });

        if (!existTeam) {
          return customResponse(res, false, 400, {}, "Team member not found.");
        }

        console.log(existTeam, "user details checking-->");

        // 2️⃣ Pull out all project IDs from both relations
        // const createdProjectIds = existTeam.created_projects.map((p) => p.id);
        const memberProjectIds = existTeam.memberProjects.map(
          (mp) => mp.project_id
        );

        // const allRelevantProjectIds = Array.from(
        //   new Set([...createdProjectIds, ...memberProjectIds])
        // );

        // 3️⃣ Fetch exactly those Backlinks whose project_id is in our list
        const backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            project_id: { in: memberProjectIds },
              uploaded_by_id:parseInt(team_id)
          },
          select: {
            id: true,
            link_url: true,
            project_id: true,
            link_status: true,
            link_rel: true,
            anchor_text: true,
            targeted_url: true,
            uploaded_by_id: true,
            created_at: true,
          },
        });

        let spreadItems = existTeam?.memberProjects[0]?.assignBY;

        const backlinksWithAssignBy = backlinks.map((backlink) => ({
          ...backlink,
          assignBY: spreadItems,
        }));
        const userDetails = { ...existTeam, backlinksWithAssignBy };
 
        userReports = userDetails;

        // backlinks = await prismaSubMasterDb.backlink.findMany({
        //   where: {
        //     deleted_at: null,
        //     project_id: Number(domain_id),
        //     ...filters,
        //   },
        //   skip: skip,
        //   take: limitInt,
        //   include: {
        //     project: true, // Include the related project details in the result
        //   },
        //   orderBy: {
        //     created_at: "desc", // Replace 'created_at' with the field you want to order by
        //   },
        //   // Limit the number of results per page
        // });

        // // Get total count for pagination info
        // totalCount = await prismaSubMasterDb.backlink.count({
        //   where: {
        //     deleted_at: null,
        //     ...filters,
        //   },
        // });
      }
    } else if (existUser?.UserInfo?.role_id == 2) {
      if (domain_id !== "") {
        console.log(domain_id, "domain id ----->");

        existTeam = await prismaSubMasterDb.User.findFirst({
          where: {
            deleted_at: null,
            id: Number(team_id),
            memberProjects: {
              some: {
                // ← use `some` to filter “users who have at least one memberProject matching this”
                project_id: parseInt(domain_id),
              },
            },
          },
          select: {
            id: true,
            email: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                organisation_id: true,
                role_id: true,
              },
            },
            memberProjects: {
              select: {
                id: true,
                project_id: true,
                assign_to: true,
                assignBY: {
                  select: {
                    id: true,
                    email: true,
                  },
                },
              },
            },
            // created_projects: {
            //   select: {
            //     id: true,
            //     domain_name: true,
            //     domain_url: true,
            //     organisation_id:true
            //   },
            // },
          },
        });

        if (!existTeam) {
          return customResponse(res, false, 400, {}, "Team member not found.");
        }

        console.log(existTeam, "user details checking-->");

        // 2️⃣ Pull out all project IDs from both relations
        // const createdProjectIds = existTeam.created_projects.map((p) => p.id);
        const memberProjectIds = existTeam.memberProjects.map(
          (mp) => mp.project_id
        );

        // const allRelevantProjectIds = Array.from(
        //   new Set([...createdProjectIds, ...memberProjectIds])
        // );

        // 3️⃣ Fetch exactly those Backlinks whose project_id is in our list
        const backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            project_id: { in: memberProjectIds },
              uploaded_by_id:parseInt(team_id)
          },
          select: {
            id: true,
            link_url: true,
            project_id: true,
            link_status: true,
            link_rel: true,
            anchor_text: true,
            targeted_url: true,
            uploaded_by_id: true,
            created_at: true,
          },
        });

        let spreadItems = existTeam?.memberProjects[0]?.assignBY;

        const backlinksWithAssignBy = backlinks.map((backlink) => ({
          ...backlink,
          assignBY: spreadItems,
        }));
        const userDetails = { ...existTeam, backlinksWithAssignBy };
 
        userReports = userDetails;

        // Get total count for pagination info
        totalCount = await prismaSubMasterDb.backlink.count({
          where: {
            deleted_at: null,
            ...filters,
          },
        });
      }

      // totalCount = await prismaSubMasterDb.backlink.count({
      //   where: {
      //     deleted_at: null,
      //     ...filters,
      //   },
      // });
    } else if (existUser?.UserInfo?.role_id == 3) {
      if (domain_id !== "") {
        console.log(domain_id, "domain id ----->");

        existTeam = await prismaSubMasterDb.User.findFirst({
          where: {
            deleted_at: null,
            id: Number(team_id),
            memberProjects: {
              some: {
                // ← use `some` to filter “users who have at least one memberProject matching this”
                project_id: parseInt(domain_id),
              },
            },
          },
          select: {
            id: true,
            email: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                organisation_id: true,
                role_id: true,
              },
            },
            memberProjects: {
              select: {
                id: true,
                project_id: true,
                assign_to: true,
                assignBY: {
                  select: {
                    id: true,
                    email: true,
                  },
                },
              },
            },
            // created_projects: {
            //   select: {
            //     id: true,
            //     domain_name: true,
            //     domain_url: true,
            //     organisation_id:true
            //   },
            // },
          },
        });

        if (!existTeam) {
          return customResponse(res, false, 400, {}, "Team member not found.");
        }

        console.log(existTeam, "user details checking-->");

        // 2️⃣ Pull out all project IDs from both relations
        // const createdProjectIds = existTeam.created_projects.map((p) => p.id);
        const memberProjectIds = existTeam.memberProjects.map(
          (mp) => mp.project_id
        );

        // const allRelevantProjectIds = Array.from(
        //   new Set([...createdProjectIds, ...memberProjectIds])
        // );

        // 3️⃣ Fetch exactly those Backlinks whose project_id is in our list
        const backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            project_id: { in: memberProjectIds },
            uploaded_by_id:parseInt(team_id)
          },
          select: {
            id: true,
            link_url: true,
            project_id: true,
            link_status: true,
            link_rel: true,
            anchor_text: true,
            targeted_url: true,
            uploaded_by_id: true,
            created_at: true,
          },
        });

        let spreadItems = existTeam?.memberProjects[0]?.assignBY;

        const backlinksWithAssignBy = backlinks.map((backlink) => ({
          ...backlink,
          assignBY: spreadItems,
        }));
        const userDetails = { ...existTeam, backlinksWithAssignBy };
  
        userReports = userDetails;

        // Get total count for pagination info
        // totalCount = await prismaSubMasterDb.backlink.count({
        //   where: {
        //     deleted_at: null,
        //     ...filters,
        //   },
        // });
      }
    } else {
      if (domain_id !== "") {
        console.log(domain_id, "domain id ----->");

        existTeam = await prismaSubMasterDb.User.findFirst({
          where: {
            deleted_at: null,
            id: Number(team_id),
            memberProjects: {
              some: {
                // ← use `some` to filter “users who have at least one memberProject matching this”
                project_id: parseInt(domain_id),
              },
            },
          },
          select: {
            id: true,
            email: true,
            UserInfo: {
              select: {
                id: true,
                user_id: true,
                organisation_id: true,
                role_id: true,
              },
            },
            memberProjects: {
              select: {
                id: true,
                project_id: true,
                assign_to: true,
                assignBY: {
                  select: {
                    id: true,
                    email: true,
                  },
                },
              },
            },
            // created_projects: {
            //   select: {
            //     id: true,
            //     domain_name: true,
            //     domain_url: true,
            //     organisation_id:true
            //   },
            // },
          },
        });

        if (!existTeam) {
          return customResponse(res, false, 400, {}, "Team member not found.");
        }

        console.log(existTeam, "user details checking-->");

        // 2️⃣ Pull out all project IDs from both relations
        // const createdProjectIds = existTeam.created_projects.map((p) => p.id);
        const memberProjectIds = existTeam.memberProjects.map(
          (mp) => mp.project_id
        );

        // const allRelevantProjectIds = Array.from(
        //   new Set([...createdProjectIds, ...memberProjectIds])
        // );

        // 3️⃣ Fetch exactly those Backlinks whose project_id is in our list
        const backlinks = await prismaSubMasterDb.backlink.findMany({
          where: {
            project_id: { in: memberProjectIds },
              uploaded_by_id:parseInt(team_id)
          },
          select: {
            id: true,
            link_url: true,
            project_id: true,
            link_status: true,
            link_rel: true,
            anchor_text: true,
            targeted_url: true,
            uploaded_by_id: true,
            created_at: true,
          },
        });

        let spreadItems = existTeam?.memberProjects[0]?.assignBY;

        const backlinksWithAssignBy = backlinks.map((backlink) => ({
          ...backlink,
          assignBY: spreadItems,
        }));
        const userDetails = { ...existTeam, backlinksWithAssignBy };
  
        userReports = userDetails;
      }
    }

    // Calculate total pages
    const totalPages = Math.ceil(totalCount / limitInt);

    // Prepare the response data
    data = {
      userReports,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err, "err in code");
    return responseHandler.error(res, err, "error", 500);
  }
};

// link checking //
const linkChecker = (req, res) => {
  try {
  } catch (err) {
    responseHandler.error(res, errorCodes.BAD_REQUEST, "Something went wrong.");
  }
};

const linkJobs = async (req, res) => {
  try {
    let data = {};
    const userData = req.user;

    const ROLE = Object.getOwnPropertyNames(userData)[0];
    // EXIST AUTH USER //
    const existUser = await prismaSubMasterDb.User.findUnique({
      where: {
        id: userData[ROLE].id,
        deleted_at: null,
      },
    });

    if (!existUser) {
      return responseHandler.error(
        res,
        errorCodes.USER_NOT_EXIST,
        errorCodes.USER_NOT_EXIST,
        400
      );
    }

    const {
      page_no = 1,
      rows = 10,
      domain_id = "",
      user_id = "",
      type = "",
      status = "",
    } = req.query;

    const pageInt = parseInt(page_no, 10);
    const limitInt = parseInt(rows, 10);

    if (pageInt < 1 || limitInt < 1) {
      return responseHandler.error(res, "Invalid pagination parameters", 400);
    }

    // Calculate skip based on the current page
    const skip = (pageInt - 1) * limitInt;

    let fetchJobs;
    let totalCount;
    if (existUser.role_id === 1) {
      fetchJobs = await prismaSubMasterDb.userJobs.findMany({
        where: {
          status: status,
        },

        skip: skip,
        take: limitInt,

        include: {
          jobProjects: true,
          usersJobs: true,
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      totalCount = await prismaSubMasterDb.userJobs.count({
        where: {
          status: status,
        },
      });
    } else if (existUser.role_id === 2) {
      // fetch porject assign to org
      const fetchAssignProjects = await prismaSubMasterDb.ProjectUser.findMany({
        where: {
          // status: status,
          assign_to: existUser.id,
        },
        include: {
          userProjects: true,
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      // fetch project created by org
      const fetchOrgProject = await prismaSubMasterDb.Project.findMany({
        where: {
          // status: status,
          created_by_id: existUser.id,
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      // get projects array from obj
      const AllProject = fetchAssignProjects.map((item) => item.userProjects);

      // merge both project array
      const mergedProjects = [...AllProject, ...fetchOrgProject];

      // create unique id set of projects//
      const projectIds = [
        ...new Set(mergedProjects.map((project) => project.id)),
      ];

      // fetch jobs related to projects//
      fetchJobs = await prismaSubMasterDb.UserJobs.findMany({
        where: {
          status: status,
          project_id: {
            in: projectIds, // Filter by the unique project IDs
          },
        },
        include: {
          jobProjects: true, // Include related project data (assuming this is the relation for projects)
          usersJobs: true, // Include related user data (assuming this is the relation for users)
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      totalCount = fetchJobs?.length;
    } else if (existUser.role_id === 3) {
      // fetch user or leads assigned by manager
      const fetchProjectsMemebrs = await prismaSubMasterDb.ProjectUser.findMany(
        {
          where: {
            // status: status,
            deleted_at: null,
            assign_by: existUser.id,
          },
          include: {
            userProjects: true,
          },
          orderBy: {
            id: "desc", // Orders by 'id' in descending order
          },
        }
      );

      // if manager id array //
      const leadsIdArray = Array.from(
        new Set(fetchProjectsMemebrs.map((item) => item.assign_to))
      );

      // fetch user based on leads id
      const fetchLeadsProjectsManager =
        await prismaSubMasterDb.ProjectUser.findMany({
          where: {
            // status: status,
            deleted_at: null,
            assign_by: {
              in: leadsIdArray,
            },
          },
          include: {
            userProjects: true,
          },
          orderBy: {
            id: "desc", // Orders by 'id' in descending order
          },
        });

      // mergere both array
      const mergedProjects = [
        ...fetchProjectsMemebrs,
        ...fetchLeadsProjectsManager,
      ];

      // create unique set of user id
      const userIds = [
        ...new Set(mergedProjects.map((user) => user?.assign_to)),
      ];

      // fetch jobs based on user id//
      fetchJobs = await prismaSubMasterDb.UserJobs.findMany({
        where: {
          status: status,
          user_id: {
            in: userIds,
          },
          // project_id: {
          //   in: projectIds, // Filter by the unique project IDs
          // },
        },
        include: {
          jobProjects: true, // Include related project data (assuming this is the relation for projects)
          usersJobs: true, // Include related user data (assuming this is the relation for users)
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      totalCount = fetchJobs?.length;
    } else if (existUser.role_id === 4) {
      const fetchProjects = await prismaSubMasterDb.ProjectUser.findMany({
        where: {
          deleted_at: null,
          assign_by: existUser.id,
        },
        include: {
          userProjects: true,
          assignTo: true,
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });

      // create set of user ids //

      const userIds = Array.from(
        new Set(fetchProjects.map((item) => item.assign_to))
      );

      // fetch jobs based on user id//
      fetchJobs = await prismaSubMasterDb.UserJobs.findMany({
        where: {
          status: status,
          user_id: {
            in: userIds,
          },
          // project_id: {
          //   in: projectIds, // Filter by the unique project IDs
          // },
        },
        include: {
          jobProjects: true, // Include related project data (assuming this is the relation for projects)
          usersJobs: true, // Include related user data (assuming this is the relation for users)
        },
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });
      totalCount = fetchJobs?.length;
    } else {
      fetchJobs = await prismaSubMasterDb.userJobs.findMany({
        where: {
          // deleted_at: null,
          user_id: existUser.id,
          status: status,
        },

        skip: skip,
        take: limitInt,
        orderBy: {
          id: "desc", // Orders by 'id' in descending order
        },
      });
    }

    totalCount = await prismaSubMasterDb.userJobs.count({
      where: {
        // deleted_at: null,
        user_id: user_id !== "" ? user_id : existUser.id,
        status: status,
      },
    });

    const totalPages = Math.ceil(totalCount / limitInt);

    data = {
      jobs: fetchJobs,
      totalCount,
      totalPages,
      currentPage: pageInt,
      limitPerPage: limitInt,
    };

    return responseHandler.success(res, data, "success", 200);
  } catch (err) {
    console.log(err, "err in code");
    return responseHandler.error(
      res,
      err.message,
      "err while fetching links",
      500
    );
  }
};

const updateBackLinks = (req, res) => {};
export {
  addBackLinks,
  getAllLinks,
  addLinksManually,
  linkChecker,
  linkJobs,
  getReportsinks,
};
