import { Router } from "express";
import { allRoles, createDomainCategory, createOrganisation, createPermissions, createRoles, createUser, fetchAllSubscriptions, fetchAllUsersAdmin, getAllPermissions, login } from "./adminController.js";
import { authenticateAdmin, } from "../../middlewares/adminMiddleware.js";
import { handleProfileUpload } from "../../middlewares/multer.js";
import { authenticateUser } from "../../middlewares/authMiddleware.js";


const adminRouter = Router()


adminRouter.post("/create-role",authenticateAdmin,createRoles)

adminRouter.get("/get-all-roles", authenticateAdmin ,allRoles)

adminRouter.post("/create-permission",authenticateAdmin,createPermissions)

adminRouter.get("/get-all-permission",authenticateAdmin,getAllPermissions)

adminRouter.post("/create-category",createDomainCategory)



adminRouter.get("/fetch-all-subscription",authenticateUser,fetchAllSubscriptions)
adminRouter.post("/login",login)



// adminRouter.get("/all-users",authenticateAdmin,fetchAllUsers)

adminRouter.post("/create-user",authenticateAdmin,handleProfileUpload,createUser)


adminRouter.get("/fetch-all-organisation",authenticateUser,fetchAllUsersAdmin)


adminRouter.post("/create-organisation",authenticateUser,createOrganisation)
export default adminRouter;