from rest_framework import serializers

from account.models import Account
from django.db.models import Q
from datetime import datetime

class RegistrationSerializer(serializers.ModelSerializer):

	password2 = serializers.CharField(style={'input_type': 'password'}, write_only=True)

	class Meta:
		model = Account
		# fields = ['email', 'username', 'designation','password', 'password2']
		fields = ['email', 'username','password', 'password2']
		extra_kwargs = {
			'password': {'write_only': True},
		}	


	def	save(self):

		account = Account(
					email=self.validated_data['email'],
					username=self.validated_data['username']
				)
		password = self.validated_data['password']
		password2 = self.validated_data['password2']
		
		if password != password2:
			raise serializers.ValidationError({'password': 'Passwords must match'})
		account.set_password(password)
		account.account_status="normal"
		account.last_login = datetime.now()
		account.last_logout = datetime.now() 
		
		account.save()
		return account 


class ChangePasswordSerializer(serializers.Serializer):

	old_password 				= serializers.CharField(required=True)
	new_password 				= serializers.CharField(required=True)
	confirm_new_password 		= serializers.CharField(required=True)