from django.urls import path
from serp import views, keyword_rank_tracker as KWDRT, keyword_insight_tracker as KWDIT , keyword_traffic_tracker as KWTT

urlpatterns = [
    path("getsetting", views.getsetting, name="get_setting"),
    path("getallprojects", views.getAllProjects, name="get_all_projects"),
    path("getallkeywords", views.getAllKeywords, name="get_all_keywords"),
    path("addproject", views.addProject, name="add_project"),
    path("addkeyword", views.addKeyword, name="add_keyword"),
    path("addcompetitor", views.addCompetitor, name="add_competitor"),
    path("getcompetitor", views.getCompetitor, name="get_competitor"),
    path("getprojectcompetitors", views.getProjectCompetitors, name="get_project_competitors"),
    path("deletecompetitor", views.deleteCompetitor, name="delete_competitor"),
    path("keywordranktracker/<int:sort_order>", KWDRT.keywordRanker, name="keyword_rank_tracker"),
    path("keywordinsighttracker/<int:sort_order>", KWDIT.insightTracker, name="keyword_insight_tracker"),
    path("keywordtraffictracker/", KWTT.keywordTraffic,name="keyword_traffic_tracker"),
    path("competitormatchkeywords", views.competitorMatchKeywords, name="competitor_match_keywords"),
    path("scheduleRankTracking", views.scheduleRankTracking, name="schedule_rank_tracking"),
    path("scheduleMetricsTracking", views.scheduleMetricsTracking, name="schedule_metrics_tracking"),
    path("scheduleMetricsTrackingKeywords", views.scheduleMetricsTrackingKeywords, name="scheduleMetricsTrackingKeywords"),
]
