from rest_framework import status
from rest_framework.response import Response
from rest_framework.decorators import api_view, permission_classes

from account.api.serializers import RegistrationSerializer, ChangePasswordSerializer
from rest_framework.authtoken.models import Token

from django.contrib.auth import authenticate
from django.views.decorators.csrf import csrf_exempt
from rest_framework.permissions import AllowAny
#password update
from rest_framework.generics import UpdateAPIView
from serp.tracker import userTrackerRequest
from serp.models import Mailrecords
from account.models import Account
from rest_framework.permissions import IsAuthenticated
from rest_framework.authentication import TokenAuthentication
from datetime import date,datetime,timedelta
from rest_framework.status import (
    HTTP_400_BAD_REQUEST,
    HTTP_404_NOT_FOUND,
    HTTP_200_OK
)

@csrf_exempt
@api_view(['POST', ])
@permission_classes((AllowAny,))
def registration_view(request):

    if request.method == 'POST':
        serializer = RegistrationSerializer(data=request.data)
        data = {}
        if serializer.is_valid():
            account = serializer.save()

            data['status'] = 'true'
            data['message'] = 'Registered successfully'
            data['email'] = account.email
            data['username'] = account.username
            data['id'] = account.id
            token = Token.objects.get(user=account).key
            data['token'] = token
        else:
            data['status'] = 'false'
            data['message']  = serializer.errors
        return Response(data)
        
        
        
@csrf_exempt
@api_view(["POST"])
@permission_classes((AllowAny,))
def login(request):
    username = request.data.get("username")
    password = request.data.get("password")
    if username is None or password is None:
        return Response({'status':'false','message': 'Please provide both username and password'}, 
                        status=HTTP_400_BAD_REQUEST)
    user = authenticate(username=username, password=password)
    accdata = Account.objects.filter(email=username).count()
    if accdata == 0:
        return Response({'status':'false','email': username,'message': 'You are not a user of our tool. So kindly register with the Rankmax.'},
                        status=HTTP_404_NOT_FOUND)
    else:                   
        if not user:
            return Response({'status':'false','message': 'Invalid Credentials'},
                            status=HTTP_404_NOT_FOUND)
        lastloginupdate = Account.objects.get(email=username)
        lastloginupdate.last_login = datetime.now()
        lastloginupdate.account_status="normal"
        lastloginupdate.normal_mode="enable"
        lastloginupdate.save()
        userTrackerRequest(request, lastloginupdate.id)
        token, _ = Token.objects.get_or_create(user=user)
        return Response({'status':'true','message':'Loggedin Successfully','id': token.user_id, 'token': token.key,'username':user.username,'email':user.email},
                        status=HTTP_200_OK)
                    

@csrf_exempt
@api_view(["POST"])
@permission_classes((AllowAny,))
def Glogin(request):
    username = request.data.get("email")
    name = request.data.get("name")
    googleId = request.data.get("googleId")
    #new fields
    campaign = request.data.get("campaign")
    medium = request.data.get("medium")
    source = request.data.get("source")
    referral = request.data.get("referral")
    #new fields
    if username is None or googleId is None:
        return Response({'status':'false','message': 'Please provide both username and password'},
                        status=HTTP_400_BAD_REQUEST)
    accdata = Account.objects.filter(email=username).count()
    user = Account.objects.filter(email=username).first()
    if accdata == 0:
        account = Account()
        account.email=username
        account.username=name
        account.google_id=str(googleId)
        account.account_status="social"
        account.normal_mode="disable"
        account.social_mode="google"
        account.last_login = datetime.now()
        account.last_logout = datetime.now()
        #new fields
        account.campaign=campaign
        account.medium=medium
        account.source=source
        account.referral=referral
        #new fields
        account.save()
        mailIns = Mailrecords.objects.filter(userid=0,types="google_login").first()
        if mailIns == None:
            maildata = Mailrecords()
            maildata.userid = 0
            maildata.types = "google_login"
            maildata.mail_list = [username]
            maildata.save()
        elif username not in mailIns.mail_list:
            mailIns.mail_list = mailIns.mail_list + [username]
            mailIns.save(update_fields=['mail_list'])
        data = {}
        data['status'] = 'true'
        data['type'] = 'newaccount'
        data['message'] = 'Registered successfully'
        data['email'] = account.email
        data['username'] = account.username
        data['id'] = account.id
        userTrackerRequest(request, account.id)
        token = Token.objects.get(user=account).key
        data['token'] = token
        
        return Response(data)        
    else:                   
        if not user:
            return Response({'status':'false','message': 'Invalid Credentials'},
                            status=HTTP_404_NOT_FOUND)
        lastloginupdate = Account.objects.get(email=username)
        lastloginupdate.google_id = googleId
        lastloginupdate.account_status="social"
        lastloginupdate.social_mode="google"
        lastloginupdate.last_login = datetime.now()
        lastloginupdate.save()
        userTrackerRequest(request, lastloginupdate.id)
        token, _ = Token.objects.get_or_create(user=user)
        return Response({'status':'true','type':'login','message':'Loggedin Successfully','id': token.user_id, 'token': token.key,'username':user.username,'email':user.email},
                        status=HTTP_200_OK)

                   
class ChangePasswordView(UpdateAPIView):

    serializer_class = ChangePasswordSerializer
    model = Account
    permission_classes = (IsAuthenticated,)
    authentication_classes = (TokenAuthentication,)

    def get_object(self, queryset=None):
        obj = self.request.user
        return obj

    def update(self, request, *args, **kwargs):
        self.object = self.get_object()
        serializer = self.get_serializer(data=request.data)

        if serializer.is_valid():
            # Check old password
            account_type = serializer.data.get("old_password")
            print(account_type)
            if account_type != "-":
                if not self.object.check_password(serializer.data.get("old_password")):  
                    return Response({"status":"false","message": "Old password is wrong"}, status=status.HTTP_200_OK)

            # confirm the new passwords match
            new_password = serializer.data.get("new_password")
            old_password = serializer.data.get("old_password")
            confirm_new_password = serializer.data.get("confirm_new_password")
            
            if new_password == old_password:
                return Response({"status":"false","message": "New password same as old. Try for different one"}, status=status.HTTP_200_OK)
            elif new_password != confirm_new_password:
                return Response({"status":"false","message": "New password must match with confirm password"}, status=status.HTTP_200_OK)

            # set_password also hashes the password that the user will get
            self.object.set_password(serializer.data.get("new_password"))
            self.object.normal_mode="enable"
            self.object.save()
            return Response({"status":"true","message":"Successfully changed password"}, status=status.HTTP_200_OK)

        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

@csrf_exempt
@api_view(["POST"])
@permission_classes((AllowAny,))
def serviceauthenticate(request):
    return Response({'status':'true','message':'Response Successfully'},status=HTTP_200_OK)