import mongoose from "mongoose";

// USER SCEHMA //
const UserSchema = new mongoose.Schema(
  {
    name: { type: String, required: true },

    email: { type: String, required: true },
    password: { type: String, required: true },

    isVerified: { type: Number, default: 0 },

    termsAndConditions: {
      type: Boolean,
      required: true,
    },
    status: {
      type: Number,
      enum: [0, 1, 2],
      default: 0,
    },
    createdByAdmin: {
      type: Boolean,
      default: false,
    },
    updatedById: {
      type: mongoose.Schema.Types.ObjectId,
      default: null,
    },
    createdById: {
      type: mongoose.Schema.Types.ObjectId,
      default: null,
    },

    deletedAt: { type: Date, default: null },
  },
  { timestamps: true }
);

// User details schema //
const UserDetailsSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    phoneNo: { type: Number, default: null },
    dateOfBirth: { type: Date, default: null },
    profilePicture: { type: String, default: null },
    countryRegion: { type: String, default: null },
    profilePictureId: { type: String, default: null },
    countryCode: { type: String, default: null },
    countryIsoCode: { type: String, default: null },
    country: { type: String, default: null },
    deletedAt: { type: Date, default: null },
    verificationToken: { type: String, default: null },
    resetPasswordToken: { type: String, default: null },
    recoveryEmailToken: { type: String, default: null },
    refreshToken: {
      type: String,
      default: null,
    },
  },
  { timestamps: true }
);

const User = mongoose.model("User", UserSchema);

const UserDetails = mongoose.model("Userdetails", UserDetailsSchema);


export { User, UserDetails };
