/*
  Warnings:

  - You are about to drop the column `backlink_duplicate` on the `Backlink` table. All the data in the column will be lost.
  - You are about to drop the column `referring_domain` on the `Backlink` table. All the data in the column will be lost.
  - Made the column `uploaded_by_id` on table `Backlink` required. This step will fail if there are existing NULL values in that column.
  - Made the column `category_id` on table `Project` required. This step will fail if there are existing NULL values in that column.
  - Added the required column `user_id` to the `ProjectCategory` table without a default value. This is not possible if the table is not empty.

*/
-- DropForeignKey
ALTER TABLE "Project" DROP CONSTRAINT "Project_category_id_fkey";

-- AlterTable
ALTER TABLE "Backlink" DROP COLUMN "backlink_duplicate",
DROP COLUMN "referring_domain",
ALTER COLUMN "uploaded_by_id" SET NOT NULL;

-- AlterTable
ALTER TABLE "Project" ALTER COLUMN "category_id" SET NOT NULL;

-- AlterTable
ALTER TABLE "ProjectCategory" ADD COLUMN     "user_id" INTEGER NOT NULL;

-- AddForeignKey
ALTER TABLE "ProjectCategory" ADD CONSTRAINT "custom_project_category_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "User"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ProjectCategory" ADD CONSTRAINT "ProjectCategory_user_id_fkey" FOREIGN KEY ("user_id") REFERENCES "User"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Project" ADD CONSTRAINT "Project_category_id_fkey" FOREIGN KEY ("category_id") REFERENCES "ProjectCategory"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Backlink" ADD CONSTRAINT "Backlink_uploaded_by_id_fkey" FOREIGN KEY ("uploaded_by_id") REFERENCES "User"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Backlink" ADD CONSTRAINT "Backlink_project_id_fkey" FOREIGN KEY ("project_id") REFERENCES "Project"("id") ON DELETE RESTRICT ON UPDATE CASCADE;
