import dotenv from "dotenv";
import mongoose from "mongoose";
dotenv.config();

// database connection//
const connectDB = async () => {

  try {
    let mongoURI;
    // Read MongoDB URI from environment variables //
    if (process.env.NODE_ENV === "production") {
      mongoURI = process.env.PRODUCTION_MONGO_URL;
    } else {
    
      mongoURI = process.env.MONGO_DB_URL;
    }
    // Connect to MongoDB using Mongoose //
    await mongoose.connect(mongoURI);
  } catch (error) {
    console.error("Error connecting to MongoDB:", error.message);
    process.exit(1); // Exit process with failure
  }
};

export default connectDB;
